/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;

public class P2VersionFinder
extends AbstractVersionFinder {
    private final IMetadataRepository mdr;

    public P2VersionFinder(Provider provider, IComponentType componentType, NodeQuery query, IMetadataRepository mdr) {
        super(provider, componentType, query);
        this.mdr = mdr;
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        VersionRange range;
        IQuery query;
        IQueryResult result;
        ComponentRequest request = this.getQuery().getComponentRequest();
        IComponentType ctype = request.getComponentType();
        boolean isFeature = ctype != null && ctype.getId().equals("eclipse.feature");
        String name = request.getName();
        if (isFeature && !name.endsWith(".feature.group")) {
            name = String.valueOf(name) + ".feature.group";
        }
        if ((result = this.mdr.query(query = (range = request.getVersionRange()) == null || range.equals((Object)VersionRange.emptyRange) ? QueryUtil.createQuery((String)"select(x | x.id == $0).latest()", (Object[])new Object[]{name}) : QueryUtil.createQuery((String)"select(x | x.id == $0 && x.version ~= $1).latest()", (Object[])new Object[]{name, range}), monitor)).isEmpty()) {
            return null;
        }
        IInstallableUnit best = (IInstallableUnit)result.iterator().next();
        return new VersionMatch(best.getVersion(), null, -1L, null, best.getId());
    }
}

