/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.net.URL;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.resolver.ResourceMapResolverFactory;
import org.eclipse.buckminster.core.rmap.model.Matcher;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Redirect
extends Matcher {
    public static final String TAG = "redirect";
    public static final String ATTR_HREF = "href";
    private final String url;

    public Redirect(ResourceMap owner, String pattern, Filter resolutionFilter, String url) {
        super(owner, pattern, resolutionFilter);
        this.url = url;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public ResourceMap getResourceMap(NodeQuery query) throws CoreException {
        ResourceMap rmap = this.getOwner();
        String expanded = ExpandingProperties.expand(rmap.getProperties(query.getProperties()), this.url, 0);
        URL resolvedURL = URLUtils.resolveURL((URL)rmap.getContextURL(), (String)expanded);
        query.logDecision(ResolverDecisionType.REDIRECT_TO_RESOURCE_MAP, resolvedURL);
        return ResourceMapResolverFactory.getCachedResourceMap(query.getResolutionContext(), resolvedURL, query.getComponentQuery().getConnectContext());
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_HREF, (String)this.url);
        super.addAttributes(attrs);
    }
}

