/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IExecutionDataSource;
import com.mountainminds.eclemma.core.URLExecutionDataSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;

public final class ExecutionDataFiles {
    private static final String FOLDER = ".execdata/";
    private final File folder;

    public ExecutionDataFiles(IPath stateLocation) {
        this.folder = stateLocation.append(FOLDER).toFile();
        this.folder.mkdirs();
    }

    public void deleteTemporaryFiles() {
        File[] files;
        File[] fileArray = files = this.folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    public IExecutionDataSource newFile(IExecutionDataSource source) throws CoreException {
        try {
            File file = File.createTempFile("session", ".exec", this.folder);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            ExecutionDataWriter writer = new ExecutionDataWriter((OutputStream)out);
            source.accept((IExecutionDataVisitor)writer, (ISessionInfoVisitor)writer);
            ((OutputStream)out).close();
            return new URLExecutionDataSource(file.toURL());
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.EXEC_FILE_CREATE_ERROR.getStatus(e));
        }
    }
}

