/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.internal.core.DebugOptions;
import com.mountainminds.eclemma.internal.core.analysis.ITypeVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TypeTraverser {
    private static final DebugOptions.ITracer TRACER = DebugOptions.ANALYSISTRACER;
    private final IPackageFragmentRoot root;

    public TypeTraverser(IPackageFragmentRoot root) {
        this.root = root;
    }

    public void process(ITypeVisitor visitor, IProgressMonitor monitor) throws JavaModelException {
        if (this.isOnClasspath(this.root)) {
            IJavaElement[] children = this.root.getChildren();
            monitor.beginTask("", children.length);
            IJavaElement[] iJavaElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (!monitor.isCanceled()) {
                    SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1);
                    this.processPackageFragment(visitor, (IPackageFragment)element, (IProgressMonitor)submonitor);
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            TRACER.trace("Package fragment root {0} not on classpath.", this.root.getPath());
        }
        monitor.done();
    }

    private boolean isOnClasspath(IPackageFragmentRoot root) throws JavaModelException {
        IPath path = root.getPath();
        IJavaProject project = root.getJavaProject();
        return project.findPackageFragmentRoot(path) != null;
    }

    private void processPackageFragment(ITypeVisitor visitor, IPackageFragment fragment, IProgressMonitor monitor) throws JavaModelException {
        block0 : switch (fragment.getKind()) {
            case 1: {
                ICompilationUnit[] units = fragment.getCompilationUnits();
                monitor.beginTask("", units.length);
                ICompilationUnit[] iCompilationUnitArray = units;
                int n = units.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit unit = iCompilationUnitArray[n2];
                    if (monitor.isCanceled()) break block0;
                    this.processCompilationUnit(visitor, unit, monitor);
                    monitor.worked(1);
                    ++n2;
                }
                break;
            }
            case 2: {
                IClassFile[] classfiles = fragment.getClassFiles();
                monitor.beginTask("", classfiles.length);
                IClassFile[] iClassFileArray = classfiles;
                int n = classfiles.length;
                int n3 = 0;
                while (n3 < n) {
                    IClassFile classfile = iClassFileArray[n3];
                    if (monitor.isCanceled()) break block0;
                    this.processClassFile(visitor, classfile, monitor);
                    monitor.worked(1);
                    ++n3;
                }
                break;
            }
        }
        monitor.done();
    }

    private void processCompilationUnit(ITypeVisitor visitor, ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        visitor.visit(unit);
        IType[] iTypeArray = unit.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (monitor.isCanceled()) break;
            this.processType(visitor, new BinaryTypeName(type), type, monitor);
            ++n2;
        }
    }

    private void processClassFile(ITypeVisitor visitor, IClassFile file, IProgressMonitor monitor) throws JavaModelException {
        visitor.visit(file);
        IType type = file.getType();
        this.processType(visitor, new BinaryTypeName(type), type, monitor);
    }

    private void processType(ITypeVisitor visitor, BinaryTypeName btn, IType type, IProgressMonitor monitor) throws JavaModelException {
        String binaryname = btn.toString();
        monitor.subTask(binaryname);
        visitor.visit(type, binaryname);
        IJavaElement[] iJavaElementArray = type.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (monitor.isCanceled()) break;
            switch (child.getElementType()) {
                case 7: {
                    IType nestedtype = (IType)child;
                    this.processType(visitor, btn.nest(nestedtype), nestedtype, monitor);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.processAnonymousInnerTypes(visitor, btn, (IMember)child, monitor);
                }
            }
            ++n2;
        }
    }

    private void processAnonymousInnerTypes(ITypeVisitor visitor, BinaryTypeName btn, IMember member, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = member.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) break;
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                this.processType(visitor, btn.nest(type), type, monitor);
            }
            ++n2;
        }
    }

    private static class BinaryTypeName {
        private final String rootname;
        private final String typename;
        private final Ctr ctr;

        private BinaryTypeName(String rootname, String typename, Ctr ctr) {
            this.rootname = rootname;
            this.typename = typename;
            this.ctr = ctr;
        }

        public BinaryTypeName(IType roottype) {
            this.typename = this.rootname = roottype.getFullyQualifiedName().replace('.', '/');
            this.ctr = new Ctr();
        }

        public BinaryTypeName nest(IType type) throws JavaModelException {
            if (type.isAnonymous()) {
                return new BinaryTypeName(this.rootname, String.valueOf(this.rootname) + '$' + this.ctr.inc(), this.ctr);
            }
            return new BinaryTypeName(this.rootname, String.valueOf(this.typename) + '$' + type.getElementName(), this.ctr);
        }

        public String toString() {
            return this.typename;
        }

        private static class Ctr {
            private int i = 0;

            private Ctr() {
            }

            public int inc() {
                return ++this.i;
            }
        }
    }
}

