/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.metadata.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.IResolution;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionBuilder
implements IResolution {
    private String artifactInfo;
    private final List<String> attributes = new ArrayList<String>();
    private VersionSelector branchOrTag;
    private String componentTypeId;
    private String contentType;
    private final CSpecBuilder cspec;
    private long lastModified;
    private boolean materializable = true;
    private String remoteName;
    private Provider provider;
    private String readerTypeId;
    private String repository;
    private final ComponentRequestBuilder request = new ComponentRequestBuilder();
    private Filter resolutionFilter;
    private String revision;
    private long size = -1L;
    private Date timestamp;
    private boolean unpack = false;
    private String persistentId;

    public ResolutionBuilder() {
        this(new CSpecBuilder());
    }

    public ResolutionBuilder(CSpecBuilder cspecBuilder) {
        this.cspec = cspecBuilder;
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    public void clear() {
        this.artifactInfo = null;
        this.attributes.clear();
        this.branchOrTag = null;
        this.componentTypeId = null;
        this.contentType = null;
        this.cspec.clear();
        this.lastModified = 0L;
        this.materializable = true;
        this.remoteName = null;
        this.provider = null;
        this.readerTypeId = null;
        this.repository = null;
        this.request.clear();
        this.resolutionFilter = null;
        this.revision = null;
        this.size = -1L;
        this.timestamp = null;
        this.unpack = false;
    }

    @Override
    public String getArtifactInfo() {
        return this.artifactInfo;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public CSpec getCSpec() {
        return this.cspec.createCSpec();
    }

    public CSpecBuilder getCSpecBuilder() {
        return this.cspec;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public VersionSelector getMatchedBranchOrTag() {
        return this.branchOrTag;
    }

    @Override
    public String getPersistentId() {
        return this.persistentId;
    }

    @Override
    public Provider getProvider() {
        if (this.provider == null) {
            String componentType = this.cspec.getComponentTypeID();
            if (componentType == null) {
                componentType = "unknown";
            }
            return Provider.immutableProvider(this.readerTypeId, componentType, this.repository, this.resolutionFilter);
        }
        return this.provider;
    }

    @Override
    public String getReaderTypeId() {
        return this.readerTypeId;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public ComponentRequestBuilder getRequest() {
        return this.request;
    }

    @Override
    public Filter getResolutionFilter() {
        return this.resolutionFilter;
    }

    @Override
    public String getSelectedRevision() {
        return this.revision;
    }

    @Override
    public Date getSelectedTimestamp() {
        return this.timestamp;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public VersionMatch getVersionMatch() {
        return new VersionMatch(this.cspec.getVersion(), this.branchOrTag, this.revision, this.timestamp, this.artifactInfo);
    }

    public void initFrom(IResolution resolution) throws CoreException {
        this.clear();
        this.attributes.addAll(resolution.getAttributes());
        this.componentTypeId = resolution.getComponentTypeId();
        this.contentType = resolution.getContentType();
        this.cspec.initFrom(resolution.getCSpec());
        this.lastModified = resolution.getLastModified();
        this.materializable = resolution.isMaterializable();
        this.persistentId = resolution.getPersistentId();
        this.provider = resolution.getProvider();
        this.resolutionFilter = resolution.getResolutionFilter();
        this.remoteName = resolution.getRemoteName();
        this.repository = resolution.getRepository();
        this.request.initFrom(resolution.getRequest());
        this.size = resolution.getSize();
        this.artifactInfo = resolution.getArtifactInfo();
        this.branchOrTag = resolution.getMatchedBranchOrTag();
        this.revision = resolution.getSelectedRevision();
        this.timestamp = resolution.getSelectedTimestamp();
        this.unpack = resolution.isUnpack();
    }

    @Override
    public boolean isMaterializable() {
        return this.materializable;
    }

    @Override
    public boolean isUnpack() {
        return this.unpack;
    }

    public void setArtifactInfo(String artifactInfo) {
        this.artifactInfo = artifactInfo;
    }

    public void setAttributes(List<String> attrs) {
        this.attributes.clear();
        if (attrs != null) {
            this.attributes.addAll(attrs);
        }
    }

    public void setBranchOrTag(VersionSelector branchOrTag) {
        this.branchOrTag = branchOrTag;
    }

    public void setComponentTypeId(String componentTypeId) {
        this.componentTypeId = componentTypeId;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFileInfo(IFileInfo info) {
        if (info == null) {
            this.setContentType(null);
            this.setRemoteName(null);
            this.setLastModified(0L);
            this.setSize(-1L);
        } else {
            this.setContentType(info.getContentType());
            this.setRemoteName(info.getRemoteName());
            this.setLastModified(info.getLastModified());
            this.setSize(info.getSize());
        }
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setMaterializable(boolean materializable) {
        this.materializable = materializable;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setReaderTypeId(String readerTypeId) {
        this.readerTypeId = readerTypeId;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setResolutionFilter(Filter resolutionFilter) {
        this.resolutionFilter = resolutionFilter;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setVersionMatch(VersionMatch versionMatch) {
        if (versionMatch == null) {
            this.artifactInfo = null;
            this.branchOrTag = null;
            this.revision = null;
            this.timestamp = null;
        } else {
            this.artifactInfo = versionMatch.getArtifactInfo();
            this.branchOrTag = versionMatch.getBranchOrTag();
            this.revision = versionMatch.getRevision();
            this.timestamp = versionMatch.getTimestamp();
        }
    }
}

