/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.internal;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Date;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.Activator;
import org.eclipse.buckminster.download.internal.ProgressStatistics;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.osgi.util.NLS;

public class FileReader
extends FileTransferJob
implements IFileTransferListener {
    private boolean closeStreamWhenFinished = false;
    private Exception exception;
    private IFileInfo fileInfo;
    private long lastProgressCount;
    private long lastStatsCount;
    private IProgressMonitor monitor;
    private boolean onlyGetInfo = false;
    private OutputStream outputStream;
    private ProgressStatistics statistics;
    private final int connectionRetryCount;
    private final long connectionRetryDelay;
    private final IConnectContext connectContext;

    public FileReader(IConnectContext connectContext) {
        super(Messages.URL_reader);
        this.setSystem(true);
        this.setUser(false);
        this.connectionRetryCount = BuckminsterPreferences.getConnectionRetryCount();
        this.connectionRetryDelay = (long)BuckminsterPreferences.getConnectionRetryDelay() * 1000L;
        this.connectContext = connectContext;
    }

    public IFileInfo getLastFileInfo() {
        return this.fileInfo;
    }

    public synchronized void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            try {
                FileInfoBuilder fi = new FileInfoBuilder();
                Date lastModified = source.getRemoteLastModified();
                if (lastModified != null) {
                    fi.setLastModified(lastModified.getTime());
                }
                fi.setName(source.getRemoteFileName());
                fi.setSize(source.getFileLength());
                this.fileInfo = fi;
                if (this.onlyGetInfo) {
                    source.cancel();
                } else {
                    ((IIncomingFileTransferReceiveStartEvent)event).receive(this.outputStream, (FileTransferJob)this);
                }
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            if (this.monitor != null) {
                long fileLength = source.getFileLength();
                this.statistics = new ProgressStatistics(source.getRemoteFileName(), fileLength);
                this.monitor.beginTask(null, 1000);
                this.monitor.subTask(this.statistics.report());
                this.lastStatsCount = 0L;
                this.lastProgressCount = 0L;
            }
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            if (this.monitor != null) {
                if (this.monitor.isCanceled()) {
                    source.cancel();
                    return;
                }
                long br = source.getBytesReceived();
                long count = br - this.lastStatsCount;
                this.lastStatsCount = br;
                this.statistics.increase(count);
                if (this.statistics.shouldReport()) {
                    count = br - this.lastProgressCount;
                    this.lastProgressCount = br;
                    this.monitor.subTask(this.statistics.report());
                    this.monitor.worked((int)(1000L * count / this.statistics.getTotal()));
                }
            }
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            if (this.closeStreamWhenFinished) {
                IOUtils.close((Closeable)this.outputStream);
            }
            if (this.exception == null) {
                this.exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
                if (this.exception instanceof UserCancelledException) {
                    this.exception = null;
                }
            }
        }
    }

    public InputStream read(URL url) throws CoreException, FileNotFoundException {
        PipedOutputStream output;
        final PipedInputStream input = new PipedInputStream();
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        Buckminster.getLogger().debug("Downloading %s", new Object[]{url});
        NullProgressMonitor cancellationMonitor = new NullProgressMonitor();
        this.sendRetrieveRequest(url, output, true, false, (IProgressMonitor)cancellationMonitor);
        return new InputStream((IProgressMonitor)cancellationMonitor){
            private final /* synthetic */ IProgressMonitor val$cancellationMonitor;
            {
                this.val$cancellationMonitor = iProgressMonitor;
            }

            public int available() throws IOException {
                this.checkException();
                return input.available();
            }

            private void checkException() throws IOException {
                IOException e;
                if (FileReader.this.exception == null) {
                    return;
                }
                Throwable t = BuckminsterException.unwind((Throwable)FileReader.this.exception);
                if (t instanceof IOException) {
                    e = (IOException)t;
                } else {
                    e = new IOException(t.getMessage());
                    e.initCause(t);
                }
                throw e;
            }

            public void close() throws IOException {
                this.val$cancellationMonitor.setCanceled(true);
                IOUtils.close((Closeable)input);
                this.checkException();
            }

            public void mark(int readlimit) {
                input.mark(readlimit);
            }

            public boolean markSupported() {
                return input.markSupported();
            }

            public int read() throws IOException {
                this.checkException();
                return input.read();
            }

            public int read(byte[] b) throws IOException {
                this.checkException();
                return input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.checkException();
                return input.read(b, off, len);
            }

            public void reset() throws IOException {
                this.checkException();
                input.reset();
            }

            public long skip(long n) throws IOException {
                this.checkException();
                return input.skip(n);
            }
        };
    }

    public IFileInfo readInfo(URL url) throws CoreException, FileNotFoundException {
        this.sendRetrieveRequest(url, null, false, true, null);
        return this.getLastFileInfo();
    }

    public void readInto(URL url, OutputStream out, IProgressMonitor mon) throws CoreException, FileNotFoundException {
        try {
            try {
                this.sendRetrieveRequest(url, out, false, false, mon);
                this.join();
            }
            catch (InterruptedException e) {
                mon.setCanceled(true);
                throw new OperationCanceledException();
            }
        }
        finally {
            if (mon != null) {
                if (this.statistics == null) {
                    mon.beginTask(null, 1);
                } else {
                    this.statistics = null;
                }
                mon.done();
            }
        }
    }

    protected void sendRetrieveRequest(URL url, OutputStream out, boolean closeWhenFinished, boolean onlyInfo, IProgressMonitor mon) throws CoreException, FileNotFoundException {
        block11: {
            IRetrieveFileTransferContainerAdapter adapter = Activator.getDefault().createRetrieveFileTransfer();
            adapter.setConnectContextForAuthentication(this.connectContext);
            this.exception = null;
            this.closeStreamWhenFinished = closeWhenFinished;
            this.onlyGetInfo = onlyInfo;
            this.fileInfo = null;
            this.statistics = null;
            this.lastProgressCount = 0L;
            this.lastStatsCount = 0L;
            this.monitor = mon;
            this.outputStream = out;
            int retryCount = 0;
            while (true) {
                Throwable t;
                if (this.monitor != null && this.monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getRetrieveNamespace(), url);
                    adapter.sendRetrieveRequest(fileID, null, (IFileTransferListener)this, null);
                }
                catch (IncomingFileTransferException e) {
                    this.exception = e;
                }
                if (this.exception == null) break block11;
                if (this.exception instanceof IncomingFileTransferException && ((IncomingFileTransferException)((Object)this.exception)).getErrorCode() == 404) {
                    t = new FileNotFoundException(this.exception.getMessage());
                } else {
                    t = BuckminsterException.unwind((Throwable)this.exception);
                    while (t instanceof CoreException) {
                        Throwable t2 = ((CoreException)t).getStatus().getException();
                        if (t2 == null) {
                            throw (CoreException)t;
                        }
                        t = t2;
                    }
                }
                if (t instanceof FileNotFoundException) {
                    throw (FileNotFoundException)t;
                }
                if (!(t instanceof IOException) || retryCount >= this.connectionRetryCount) break;
                ++retryCount;
                this.exception = null;
                try {
                    Buckminster.getLogger().warning(NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{url.toString(), t.getMessage(), String.valueOf(retryCount)}), new Object[0]);
                    Thread.sleep(this.connectionRetryDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            throw BuckminsterException.wrap((Throwable)this.exception);
        }
    }
}

