/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.internal.fetchfactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.internal.fetchfactory.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IAntScript;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.Utils;

public class GITFetchTaskFactory
implements IFetchFactory {
    public static final String ID = "GIT";
    public static final String OVERRIDE_TAG = "GIT";
    private static final String TARGET_GET_ELEMENT_FROM_REPO = "GitFetchElementFromLocalRepo";
    private static final String TARGET_GET_FILE_FROM_REPO = "GitFetchFileFromLocalRepo";
    private static final String TARGET_CLONE_REPO = "GitCloneRepoToLocalRepo";
    private static final String TARGET_UPDATE_REPO = "GitUpdateLocalRepo";
    private static final String TARGET_CHECKOUT_TAG = "GitCheckoutTagInLocalRepo";
    private static final String SEPARATOR = ",";
    private static final String KEY_REPO = "repo";
    private static final String KEY_PATH = "path";
    private static final String KEY_PREBUILT = "prebuilt";
    private static final String PROP_DESTINATIONFOLDER = "destinationFolder";
    private static final String PROP_GITREPO = "gitRepo";
    private static final String PROP_GITREPO_LOCAL_PATH = "gitRepoLocalPath";
    private static final String PROP_PATH = "path";
    private static final String PROP_FILE = "file";
    private static final String PROP_TAG = "tag";
    private static final String PROP_FILETOCHECK = "fileToCheck";
    public static String PROP_FETCH_CACHE_LOCATION = "fetchCacheLocation";
    public static String DEFAULT_FETCH_CACHE_LOCATION = "${basedir}/scmCache";

    private static void printArg(IAntScript script, String value) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("value", value);
        script.printElement("arg", params);
    }

    private void addProjectReference(Map<String, String> entryInfos) {
        String sourceUrl;
        String repoLocation = entryInfos.get(KEY_REPO);
        String path = entryInfos.get("path");
        String projectName = entryInfos.get("element");
        String tag = entryInfos.get(PROP_TAG);
        if (repoLocation != null && projectName != null && (sourceUrl = this.asReference(repoLocation, path, projectName, tag)) != null) {
            entryInfos.put("sourceReferences", sourceUrl);
        }
    }

    public void addTargets(IAntScript script) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        ArrayList<String> args = new ArrayList<String>(5);
        script.printComment("Start of common Git fetch factory targets.");
        script.printTargetDeclaration("GitCheckSkipClone", null, null, null, null);
        this.printGitRepoBaseLocationDefault(script);
        this.printConditionStart(script, "skipClone", null, null);
        script.printStartTag("or");
        script.incrementIdent();
        this.printAvailableFile(script, Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH));
        this.printAvailableFile(script, Utils.getPropertyFormat((String)PROP_FILETOCHECK));
        script.decrementIdent();
        script.printEndTag("or");
        this.printConditionEnd(script);
        script.printTargetEnd();
        script.printTargetDeclaration(TARGET_CLONE_REPO, "GitCheckSkipClone", null, "skipClone", null);
        this.printGitRepoBaseLocationDefault(script);
        params.put("dir", Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH));
        script.printElement("mkdir", params);
        args.add(Utils.getPropertyFormat((String)PROP_GITREPO));
        args.add(".");
        this.printGitTask(script, "clone", args);
        script.printTargetEnd();
        script.printTargetDeclaration(TARGET_UPDATE_REPO, null, Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH), "${fileToCheck}", null);
        this.printGitRepoBaseLocationDefault(script);
        args.clear();
        args.add("--all");
        this.printGitTask(script, "fetch", null);
        script.printTargetEnd();
        script.printTargetDeclaration(TARGET_CHECKOUT_TAG, null, Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH), "${fileToCheck}", null);
        this.printGitRepoBaseLocationDefault(script);
        args.clear();
        args.add("--force");
        args.add(Utils.getPropertyFormat((String)PROP_TAG));
        this.printGitTask(script, "checkout", args);
        script.printTargetEnd();
        script.printTargetDeclaration(TARGET_GET_ELEMENT_FROM_REPO, null, Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH), "${fileToCheck}", null);
        this.printGitRepoBaseLocationDefault(script);
        params.clear();
        params.put("todir", Utils.getPropertyFormat((String)PROP_DESTINATIONFOLDER));
        script.printStartTag("copy", params);
        script.incrementIdent();
        params.clear();
        params.put("dir", String.valueOf(Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH)) + "/" + Utils.getPropertyFormat((String)"path"));
        script.printElement("fileset", params);
        script.decrementIdent();
        script.printEndTag("copy");
        script.printTargetEnd();
        script.printTargetDeclaration(TARGET_GET_FILE_FROM_REPO, null, Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH), "${fileToCheck}", null);
        this.printGitRepoBaseLocationDefault(script);
        params.clear();
        params.put(PROP_FILE, String.valueOf(Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH)) + "/" + Utils.getPropertyFormat((String)"path"));
        params.put("tofile", String.valueOf(Utils.getPropertyFormat((String)PROP_DESTINATIONFOLDER)) + "/" + Utils.getPropertyFormat((String)PROP_FILE));
        params.put("failOnError", "false");
        script.printElement("copy", params);
        script.printTargetEnd();
        script.printComment("End of common Git fetch factory targets.");
    }

    private String asLocalRepo(String repoLocation) {
        StringBuffer b = new StringBuffer(repoLocation.length());
        b.append(Utils.getPropertyFormat((String)PROP_FETCH_CACHE_LOCATION)).append('/');
        int i = 0;
        while (i < repoLocation.length()) {
            char c = repoLocation.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                b.append(c);
            } else {
                b.append('_');
            }
            ++i;
        }
        if (b.charAt(b.length() - 1) == '/') {
            return b.substring(0, b.length() - 1);
        }
        return b.toString();
    }

    private String asReference(String repoLocation, String path, String projectName, String tagName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("scm:git:");
        buffer.append(repoLocation);
        if (path != null) {
            Path projectPath = new Path(path);
            buffer.append(";path=\"");
            buffer.append(projectPath.toString());
            buffer.append('\"');
            if (!projectPath.lastSegment().equals(projectName)) {
                buffer.append(";project=\"");
                buffer.append(projectName);
                buffer.append('\"');
            }
        }
        if (tagName != null && !tagName.equals("master")) {
            buffer.append(";tag=");
            buffer.append(tagName);
        }
        return buffer.toString();
    }

    public void generateRetrieveElementCall(Map entryInfos, IPath destination, IAntScript script) {
        String gitCopyTarget;
        String type = (String)entryInfos.get("type");
        boolean prebuilt = Boolean.valueOf((String)entryInfos.get(KEY_PREBUILT));
        String gitRepo = (String)entryInfos.get(KEY_REPO);
        String localGitRepo = this.asLocalRepo(gitRepo);
        String path = (String)entryInfos.get("path");
        String tag = (String)entryInfos.get(PROP_TAG);
        this.printGitRepoBaseLocationDefault(script);
        IPath locationToCheck = null;
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put(PROP_GITREPO_LOCAL_PATH, localGitRepo);
        if (prebuilt) {
            params.put(PROP_DESTINATIONFOLDER, destination.removeLastSegments(1).toString());
            params.put("path", path);
            String prebuiltJarFile = new Path(path).lastSegment();
            params.put(PROP_FILE, prebuiltJarFile);
            locationToCheck = destination.removeLastSegments(1).append(prebuiltJarFile);
            gitCopyTarget = TARGET_GET_FILE_FROM_REPO;
        } else {
            params.put(PROP_DESTINATIONFOLDER, destination.toString());
            if (path != null) {
                params.put("path", new Path(path).makeRelative().toString());
            }
            if (type.equals("feature")) {
                locationToCheck = destination.append("feature.xml");
            } else if (type.equals("plugin")) {
                locationToCheck = destination.append("plugin.xml");
            } else if (type.equals("fragment")) {
                locationToCheck = destination.append("fragment.xml");
            } else if (type.equals("bundle")) {
                locationToCheck = destination.append("META-INF/MANIFEST.MF");
            }
            gitCopyTarget = TARGET_GET_ELEMENT_FROM_REPO;
        }
        if (locationToCheck != null) {
            params.put(PROP_FILETOCHECK, locationToCheck.toString());
            this.printAvailableTask(locationToCheck.toString(), locationToCheck.toString(), script);
            if (!prebuilt && (type.equals("plugin") || type.equals("fragment"))) {
                this.printAvailableTask(locationToCheck.toString(), destination.append("META-INF/MANIFEST.MF").toString(), script);
            }
        }
        this.printCloneRepoAndCheckoutTagTasks(script, gitRepo, localGitRepo, tag, locationToCheck);
        script.printAntCallTask(gitCopyTarget, true, params);
    }

    public void generateRetrieveFilesCall(Map entryInfos, IPath destination, String[] files, IAntScript script) {
        String gitRepo = (String)entryInfos.get(KEY_REPO);
        String localGitRepo = this.asLocalRepo(gitRepo);
        String path = (String)entryInfos.get("path");
        String tag = (String)entryInfos.get(PROP_TAG);
        this.printGitRepoBaseLocationDefault(script);
        this.printCloneRepoAndCheckoutTagTasks(script, gitRepo, localGitRepo, tag, null);
        HashMap<String, String> params = new HashMap<String, String>(4);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            IPath filePath = path != null ? new Path(path).append(file) : new Path((String)entryInfos.get("element")).append(file);
            params.clear();
            params.put(PROP_GITREPO_LOCAL_PATH, localGitRepo);
            params.put(PROP_DESTINATIONFOLDER, destination.toString());
            params.put("path", filePath.toString());
            params.put(PROP_FILE, file);
            script.printAntCallTask(TARGET_GET_FILE_FROM_REPO, true, params);
            ++i;
        }
    }

    public void parseMapFileEntry(String repoSpecificentry, Properties overrideTags, Map entryInfos) throws CoreException {
        String[] arguments = Utils.getArrayFromStringWithBlank((String)repoSpecificentry, (String)SEPARATOR);
        HashMap<String, String> table = new HashMap<String, String>();
        int i = 0;
        while (i < arguments.length) {
            String arg = arguments[i];
            int index = arg.indexOf(61);
            if (index == -1) {
                String message = NLS.bind((String)Messages.error_incorrectDirectoryEntryKeyValue, entryInfos.get("element"));
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
            }
            String key = arg.substring(0, index);
            String value = arg.substring(index + 1);
            table.put(key, value);
            ++i;
        }
        if (!table.containsKey(KEY_REPO)) {
            String message = NLS.bind((String)Messages.error_directoryEntryRequiresRepo, entryInfos.get("element"));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        String overrideTag = null;
        if (overrideTags != null) {
            overrideTag = overrideTags.getProperty((String)entryInfos.get("element"));
            if (overrideTag == null) {
                overrideTag = overrideTags.getProperty((String)table.get(KEY_REPO));
            }
            if (overrideTag == null) {
                overrideTag = overrideTags.getProperty("GIT");
            }
        }
        entryInfos.put(PROP_TAG, overrideTag != null && overrideTag.trim().length() != 0 ? overrideTag : (String)table.get(PROP_TAG));
        entryInfos.put(KEY_REPO, table.get(KEY_REPO));
        if (table.get("path") != null) {
            entryInfos.put("path", new Path((String)table.get("path")).makeRelative().removeTrailingSeparator().toString());
        }
        entryInfos.put(KEY_PREBUILT, table.get(KEY_PREBUILT));
        this.addProjectReference(entryInfos);
    }

    private void printAvailableFile(IAntScript script, String file) {
        script.println("<available file=\"" + file + "\"/>");
    }

    private void printAvailableTask(String property, String file, IAntScript script) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("property", property);
        params.put(PROP_FILE, file);
        script.printElement("available", params);
    }

    private void printCloneRepoAndCheckoutTagTasks(IAntScript script, String gitRepo, String localGitRepo, String tag, IPath locationToCheckIfPluginLocal) {
        this.printAvailableTask(localGitRepo, localGitRepo, script);
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put(PROP_GITREPO_LOCAL_PATH, localGitRepo);
        if (locationToCheckIfPluginLocal != null) {
            params.put(PROP_FILETOCHECK, locationToCheckIfPluginLocal.toString());
        }
        script.printAntCallTask(TARGET_UPDATE_REPO, true, params);
        params.put(PROP_GITREPO, gitRepo);
        params.put(PROP_GITREPO_LOCAL_PATH, localGitRepo);
        if (locationToCheckIfPluginLocal != null) {
            params.put(PROP_FILETOCHECK, locationToCheckIfPluginLocal.toString());
        }
        script.printAntCallTask(TARGET_CLONE_REPO, true, params);
        this.printAvailableTask(localGitRepo, localGitRepo, script);
        params.clear();
        params.put(PROP_GITREPO_LOCAL_PATH, localGitRepo);
        params.put(PROP_TAG, tag);
        if (locationToCheckIfPluginLocal != null) {
            params.put(PROP_FILETOCHECK, locationToCheckIfPluginLocal.toString());
        }
        script.printAntCallTask(TARGET_CHECKOUT_TAG, true, params);
    }

    private void printConditionEnd(IAntScript script) {
        script.decrementIdent();
        script.printEndTag("condition");
    }

    private void printConditionStart(IAntScript script, String property, String value, String elseValue) {
        script.printTabs();
        script.print("<condition");
        script.printAttribute("property", property, true);
        script.printAttribute("value", value, false);
        script.printAttribute("else", elseValue, false);
        script.print(">");
        script.println();
        script.incrementIdent();
    }

    private void printGitRepoBaseLocationDefault(IAntScript script) {
        script.println("<property name=\"" + PROP_FETCH_CACHE_LOCATION + "\" value=\"" + DEFAULT_FETCH_CACHE_LOCATION + "\" />");
    }

    private void printGitTask(IAntScript script, String commandName, List args) {
        StringBuffer m = new StringBuffer();
        m.append("[GIT] ");
        m.append(Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH));
        m.append(" >> git ").append(commandName);
        if (args != null) {
            int i = 0;
            while (i < args.size()) {
                m.append(" ").append(args.get(i));
                ++i;
            }
        }
        script.printEchoTask(null, m.toString(), "info");
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("executable", "git");
        params.put("dir", Utils.getPropertyFormat((String)PROP_GITREPO_LOCAL_PATH));
        params.put("failOnError", "true");
        script.printStartTag("exec", params);
        script.incrementIdent();
        GITFetchTaskFactory.printArg(script, commandName);
        if (args != null) {
            int i = 0;
            while (i < args.size()) {
                String arg = (String)args.get(i);
                GITFetchTaskFactory.printArg(script, arg);
                ++i;
            }
        }
        script.decrementIdent();
        script.printEndTag("exec");
    }
}

