/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.Component;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;

public class SystemLibraryApiComponent
extends Component {
    protected String[] fExecEnv;
    protected LibraryLocation[] fLibraries;
    protected String fLocation;
    protected String[] fSystemPackages;
    protected String fVersion;

    protected SystemLibraryApiComponent(IApiBaseline baseline) {
        super(baseline);
    }

    public SystemLibraryApiComponent(IApiBaseline baseline, ExecutionEnvironmentDescription description, String[] systemPackages) throws CoreException {
        super(baseline);
        this.init(description);
        this.fSystemPackages = systemPackages;
    }

    @Override
    protected IApiDescription createApiDescription() throws CoreException {
        ApiDescription api = new ApiDescription(this.getSymbolicName());
        int i = 0;
        while (i < this.fSystemPackages.length) {
            IPackageDescriptor pkg = Factory.packageDescriptor(this.fSystemPackages[i]);
            api.setVisibility(pkg, 1);
            ++i;
        }
        String[] packageNames = this.getPackageNames();
        int i2 = 0;
        while (i2 < packageNames.length) {
            if (packageNames[i2].startsWith("java.")) {
                IPackageDescriptor pkg = Factory.packageDescriptor(packageNames[i2]);
                api.setVisibility(pkg, 1);
            }
            ++i2;
        }
        return api;
    }

    @Override
    protected IApiFilterStore createApiFilterStore() {
        return null;
    }

    @Override
    protected List<IApiTypeContainer> createApiTypeContainers() throws CoreException {
        ArrayList<IApiTypeContainer> libs = new ArrayList<IApiTypeContainer>(this.fLibraries.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation lib = this.fLibraries[i];
            libs.add(new ArchiveApiTypeContainer(this, lib.getSystemLibraryPath().toOSString()));
            ++i;
        }
        return libs;
    }

    @Override
    public String[] getExecutionEnvironments() {
        return this.fExecEnv;
    }

    @Override
    public String getSymbolicName() {
        return this.fExecEnv[0];
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public IRequiredComponentDescription[] getRequiredComponents() {
        return new IRequiredComponentDescription[0];
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    private void init(ExecutionEnvironmentDescription description) {
        this.fLibraries = description.getLibraryLocations();
        this.fExecEnv = new String[]{description.getProperty("-Dee.class.library.level")};
        this.fVersion = this.fExecEnv[0];
        this.setName(this.fExecEnv[0]);
        this.fLocation = description.getProperty("-Djava.home");
    }

    @Override
    public boolean isSourceComponent() {
        return false;
    }

    @Override
    public boolean isSystemComponent() {
        return true;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    @Override
    public boolean hasFragments() {
        return false;
    }

    public String getOrigin() {
        return null;
    }

    @Override
    public boolean hasApiDescription() {
        return false;
    }

    @Override
    public String[] getLowestEEs() {
        return null;
    }

    @Override
    public ResolverError[] getErrors() throws CoreException {
        return null;
    }
}

