/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core.launching;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.ScopeUtils;
import com.mountainminds.eclemma.core.launching.ICoverageLauncher;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.launching.AgentArgumentSupport;
import com.mountainminds.eclemma.internal.core.launching.AgentServer;
import com.mountainminds.eclemma.internal.core.launching.CoverageLaunch;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.osgi.util.NLS;

public abstract class CoverageLauncher
implements ICoverageLauncher,
IExecutableExtension {
    public static final String DELEGATELAUNCHMODE = "run";
    protected ILaunchConfigurationDelegate launchdelegate;
    protected ILaunchConfigurationDelegate2 launchdelegate2;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String launchtype = config.getAttribute("type");
        this.launchdelegate = this.getLaunchDelegate(launchtype);
        if (this.launchdelegate instanceof ILaunchConfigurationDelegate2) {
            this.launchdelegate2 = (ILaunchConfigurationDelegate2)this.launchdelegate;
        }
    }

    private ILaunchConfigurationDelegate getLaunchDelegate(String launchtype) throws CoreException {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchtype);
        if (type == null) {
            throw new CoreException(EclEmmaStatus.UNKOWN_LAUNCH_TYPE_ERROR.getStatus(launchtype));
        }
        return type.getDelegates(Collections.singleton(DELEGATELAUNCHMODE))[0].getDelegate();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)CoreMessages.Launching_task, (Object)configuration.getName()), 2);
        if (monitor.isCanceled()) {
            return;
        }
        CoverageLaunch coverageLaunch = (CoverageLaunch)launch;
        AgentServer server = coverageLaunch.getAgentServer();
        server.start();
        AgentArgumentSupport argSupport = new AgentArgumentSupport();
        ILaunchConfiguration adjusted = argSupport.addArgument(server.getPort(), configuration);
        this.launchdelegate.launch(adjusted, DELEGATELAUNCHMODE, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new CoverageLaunch(configuration, ScopeUtils.getConfiguredScope(configuration));
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.buildForLaunch(configuration, DELEGATELAUNCHMODE, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.preLaunchCheck(configuration, DELEGATELAUNCHMODE, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.launchdelegate2 == null) {
            return true;
        }
        return this.launchdelegate2.finalLaunchCheck(configuration, DELEGATELAUNCHMODE, monitor);
    }
}

