/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core;

import com.mountainminds.eclemma.core.ICoverageSession;
import com.mountainminds.eclemma.core.IExecutionDataSource;
import com.mountainminds.eclemma.core.ISessionListener;
import com.mountainminds.eclemma.core.ISessionManager;
import com.mountainminds.eclemma.internal.core.CoreMessages;
import com.mountainminds.eclemma.internal.core.CoverageSession;
import com.mountainminds.eclemma.internal.core.ExecutionDataFiles;
import com.mountainminds.eclemma.internal.core.MemoryExecutionDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IPackageFragmentRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
implements ISessionManager {
    private final ExecutionDataFiles executiondatafiles;
    private final Object lock;
    private final List<ISessionListener> listeners;
    private final List<ICoverageSession> sessions;
    private final Map<Object, List<ICoverageSession>> launchmap;
    private ICoverageSession activeSession;

    public SessionManager(ExecutionDataFiles executiondatafiles) {
        this.executiondatafiles = executiondatafiles;
        this.lock = new Object();
        this.listeners = new ArrayList<ISessionListener>();
        this.sessions = new ArrayList<ICoverageSession>();
        this.launchmap = new HashMap<Object, List<ICoverageSession>>();
        this.activeSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(ICoverageSession session, boolean activate, ILaunch launch) {
        Object object = this.lock;
        synchronized (object) {
            if (session == null) {
                throw new IllegalArgumentException();
            }
            if (!this.sessions.contains(session)) {
                this.sessions.add(session);
                if (launch != null) {
                    List<ICoverageSession> l = this.launchmap.get(launch);
                    if (l == null) {
                        l = new ArrayList<ICoverageSession>();
                        this.launchmap.put(launch, l);
                    }
                    l.add(session);
                }
                this.fireSessionAdded(session);
            }
            if (activate) {
                this.activeSession = session;
                this.fireSessionActivated(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ICoverageSession session) {
        Object object = this.lock;
        synchronized (object) {
            this.removeSessions(Collections.singleton(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionsFor(ILaunch launch) {
        Object object = this.lock;
        synchronized (object) {
            List<ICoverageSession> sessionsToRemove = this.launchmap.get(launch);
            if (sessionsToRemove != null) {
                this.removeSessions(sessionsToRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllSessions() {
        Object object = this.lock;
        synchronized (object) {
            this.removeSessions(this.sessions);
        }
    }

    private void removeSessions(Collection<ICoverageSession> sessionsToRemove) {
        sessionsToRemove = new ArrayList<ICoverageSession>(sessionsToRemove);
        ArrayList<ICoverageSession> removedSessions = new ArrayList<ICoverageSession>();
        for (ICoverageSession s : sessionsToRemove) {
            if (!this.sessions.remove(s)) continue;
            removedSessions.add(s);
            for (List<ICoverageSession> mappedSessions : this.launchmap.values()) {
                mappedSessions.remove(s);
            }
        }
        boolean actived = sessionsToRemove.contains(this.activeSession);
        if (actived) {
            int size = this.sessions.size();
            this.activeSession = size == 0 ? null : this.sessions.get(size - 1);
        }
        for (ICoverageSession s : removedSessions) {
            this.fireSessionRemoved(s);
        }
        if (actived) {
            this.fireSessionActivated(this.activeSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ICoverageSession> getSessions() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<ICoverageSession>(this.sessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateSession(ICoverageSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.sessions.contains(session) && !session.equals(this.activeSession)) {
                this.activeSession = session;
                this.fireSessionActivated(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICoverageSession getActiveSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.activeSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshActiveSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeSession != null) {
                this.fireSessionActivated(this.activeSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICoverageSession mergeSessions(Collection<ICoverageSession> sessions, String description, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreMessages.MergingCoverageSessions_task, sessions.size());
        HashSet<IPackageFragmentRoot> scope = new HashSet<IPackageFragmentRoot>();
        HashSet<ILaunchConfiguration> launches = new HashSet<ILaunchConfiguration>();
        MemoryExecutionDataSource memory = new MemoryExecutionDataSource();
        for (ICoverageSession session : sessions) {
            scope.addAll(session.getScope());
            if (session.getLaunchConfiguration() != null) {
                launches.add(session.getLaunchConfiguration());
            }
            session.accept(memory, memory);
            monitor.worked(1);
        }
        IExecutionDataSource executionDataSource = this.executiondatafiles.newFile(memory);
        ILaunchConfiguration launchconfiguration = launches.size() == 1 ? (ILaunchConfiguration)launches.iterator().next() : null;
        CoverageSession merged = new CoverageSession(description, scope, executionDataSource, launchconfiguration);
        Object object = this.lock;
        synchronized (object) {
            this.addSession(merged, true, null);
            for (ICoverageSession session : sessions) {
                this.removeSession(session);
            }
        }
        monitor.done();
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSessionListener(ISessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionListener(ISessionListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    private void fireSessionAdded(ICoverageSession session) {
        for (ISessionListener l : new ArrayList<ISessionListener>(this.listeners)) {
            l.sessionAdded(session);
        }
    }

    private void fireSessionRemoved(ICoverageSession session) {
        for (ISessionListener l : new ArrayList<ISessionListener>(this.listeners)) {
            l.sessionRemoved(session);
        }
    }

    private void fireSessionActivated(ICoverageSession session) {
        for (ISessionListener l : new ArrayList<ISessionListener>(this.listeners)) {
            l.sessionActivated(session);
        }
    }
}

