/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import com.mountainminds.eclemma.internal.core.analysis.SignatureResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MethodLocator {
    private final Map<String, IMethod> indexParamCount = new HashMap<String, IMethod>();
    private final Set<String> ambiguous = new HashSet<String>();
    private final Map<String, IMethod> indexParamSignature = new HashMap<String, IMethod>();
    private final IType type;

    public MethodLocator(IType type) throws JavaModelException {
        this.type = type;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            this.addToIndex(m);
            ++n2;
        }
    }

    public IMethod findMethod(String name, String signature) {
        String paramCountKey;
        if ("<init>".equals(name)) {
            name = this.type.getElementName();
        }
        if (this.ambiguous.contains(paramCountKey = this.createParamCountKey(name, signature))) {
            return this.indexParamSignature.get(this.createParamSignatureKey(name, signature));
        }
        return this.indexParamCount.get(paramCountKey);
    }

    private void addToIndex(IMethod method) throws JavaModelException {
        String paramCountKey = this.createParamCountKey(method);
        if (this.ambiguous.contains(paramCountKey)) {
            this.indexParamSignature.put(this.createParamSignatureKey(method), method);
        } else {
            IMethod existing = this.indexParamCount.get(paramCountKey);
            if (existing == null) {
                this.indexParamCount.put(paramCountKey, method);
            } else {
                this.ambiguous.add(paramCountKey);
                this.indexParamSignature.put(this.createParamSignatureKey(existing), existing);
                this.indexParamSignature.put(this.createParamSignatureKey(method), method);
            }
        }
    }

    private String createParamCountKey(IMethod method) {
        return String.valueOf(method.getElementName()) + "@" + method.getParameterTypes().length;
    }

    private String createParamCountKey(String name, String fullSignature) {
        return String.valueOf(name) + "@" + Signature.getParameterCount((String)fullSignature);
    }

    private String createParamSignatureKey(IMethod method) throws JavaModelException {
        return String.valueOf(method.getElementName()) + "#" + SignatureResolver.getParameters(method);
    }

    private String createParamSignatureKey(String name, String fullSignature) {
        return String.valueOf(name) + "#" + SignatureResolver.getParameters(fullSignature);
    }
}

