/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.parser;

import java.util.ArrayList;
import org.eclipse.buckminster.core.common.model.Flow;
import org.eclipse.buckminster.core.common.model.FlowWithAttributes;
import org.eclipse.buckminster.core.common.model.Text;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FlowHandler
extends ChildHandler
implements ChildPoppedListener {
    private static final ISaxableElement[] noChildren = new ISaxableElement[0];
    private final String localName;
    private String[] keyValuePairs;
    private ArrayList<ISaxableElement> elements;
    private StringBuilder text;

    protected FlowHandler(AbstractHandler parentHandler, String localName) {
        super(parentHandler);
        this.localName = localName;
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        this.text.append(chars, start, length);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        this.addElement(((FlowHandler)child).createElement());
    }

    public Flow createElement() {
        this.addTextIfAny();
        ISaxableElement[] children = this.elements == null ? noChildren : this.elements.toArray(new ISaxableElement[this.elements.size()]);
        return this.createFlowElement(this.localName, this.keyValuePairs, children);
    }

    public ChildHandler createHandler(String uri, String name, Attributes attrs) throws SAXException {
        this.addTextIfAny();
        return new FlowHandler((AbstractHandler)this, name);
    }

    public String getTAG() {
        return this.localName;
    }

    public void handleAttributes(Attributes attrs) {
        int numAttrs = attrs.getLength();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.text != null) {
            this.text.setLength(0);
        }
        if (numAttrs > 0) {
            this.keyValuePairs = new String[numAttrs * 2];
            int idx = 0;
            while (idx < numAttrs) {
                int kaIdx = idx * 2;
                this.keyValuePairs[kaIdx] = attrs.getLocalName(idx);
                this.keyValuePairs[kaIdx + 1] = attrs.getValue(idx);
                ++idx;
            }
        } else {
            this.keyValuePairs = Trivial.EMPTY_STRING_ARRAY;
        }
    }

    Flow createFlowElement(String name, String[] keyValPairs, ISaxableElement[] children) {
        return keyValPairs.length == 0 ? new Flow(name, children) : new FlowWithAttributes(name, children, keyValPairs);
    }

    private void addElement(ISaxableElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(element);
    }

    private void addTextIfAny() {
        if (this.text == null) {
            return;
        }
        int textLen = this.text.length();
        if (textLen == 0) {
            return;
        }
        char[] buf = new char[textLen];
        this.text.getChars(0, textLen, buf, 0);
        this.addElement(new Text(buf));
        this.text.setLength(0);
    }
}

