/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.mspec.model;

import java.util.regex.Pattern;
import org.eclipse.buckminster.core.mspec.IMaterializationNode;
import org.eclipse.buckminster.core.mspec.builder.MaterializationNodeBuilder;
import org.eclipse.buckminster.core.mspec.model.MaterializationDirective;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MaterializationNode
extends MaterializationDirective
implements IMaterializationNode {
    public static final String TAG = "mspecNode";
    public static final String ATTR_NAME_PATTERN = "namePattern";
    public static final String ATTR_FILTER = "filter";
    public static final String ATTR_LEAF_ARTIFACT = "leafArtifact";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_EXCLUDE = "exclude";
    public static final String ATTR_RESOURCE_PATH = "resourcePath";
    public static final String ATTR_BINDING_NAME_PATTERN = "bindingNamePattern";
    public static final String ATTR_BINDING_NAME_REPLACEMENT = "bindingNameReplacement";
    public static final String ELEM_UNPACK = "unpack";
    public static final String ATTR_SUFFIX = "suffix";
    public static final String ATTR_EXPAND = "expand";
    private final Pattern namePattern;
    private final Filter filter;
    private final IPath leafArtifact;
    private final String componentTypeID;
    private final boolean exclude;
    private final IPath resourcePath;
    private final Pattern bindingNamePattern;
    private final String bindingNameReplacement;
    private final String suffix;
    private final boolean unpack;
    private final boolean expand;

    public MaterializationNode(MaterializationNodeBuilder builder) {
        super(builder);
        this.namePattern = builder.getNamePattern();
        this.filter = builder.getFilter();
        this.leafArtifact = builder.getLeafArtifact();
        this.componentTypeID = builder.getComponentTypeID();
        this.exclude = builder.isExclude();
        this.resourcePath = builder.getResourcePath();
        this.bindingNamePattern = builder.getBindingNamePattern();
        this.bindingNameReplacement = builder.getBindingNameReplacement();
        this.suffix = builder.getSuffix();
        this.unpack = builder.isUnpack();
        this.expand = builder.isExpand();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(MaterializationNodeBuilder.class)) {
            MaterializationNodeBuilder bld = new MaterializationNodeBuilder();
            bld.initFrom(this);
            return bld;
        }
        return super.getAdapter(adapter);
    }

    public Pattern getBindingNamePattern() {
        return this.bindingNamePattern;
    }

    public String getBindingNameReplacement() {
        return this.bindingNameReplacement;
    }

    public String getComponentTypeID() {
        return this.componentTypeID;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public IPath getLeafArtifact() {
        return this.leafArtifact;
    }

    public Pattern getNamePattern() {
        return this.namePattern;
    }

    public IPath getResourcePath() {
        return this.resourcePath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public boolean isExpand() {
        return this.expand;
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        if (this.namePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_NAME_PATTERN, (String)this.namePattern.toString());
        }
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
        if (this.componentTypeID != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.componentTypeID);
        }
        if (this.leafArtifact != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_LEAF_ARTIFACT, (String)this.leafArtifact.toPortableString());
        }
        if (this.resourcePath != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOURCE_PATH, (String)this.resourcePath.toPortableString());
        }
        if (this.exclude) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXCLUDE, (String)"true");
        }
        if (this.bindingNamePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BINDING_NAME_PATTERN, (String)this.bindingNamePattern.toString());
        }
        if (this.bindingNameReplacement != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BINDING_NAME_REPLACEMENT, (String)this.bindingNameReplacement);
        }
    }

    protected void emitElements(ContentHandler receiver, String namespace, String prefix) throws SAXException {
        super.emitElements(receiver, namespace, prefix);
        if (this.unpack) {
            AttributesImpl attrs = new AttributesImpl();
            if (!this.expand) {
                Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXPAND, (String)"false");
            }
            if (this.suffix != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SUFFIX, (String)this.suffix);
            }
            String qName = Utils.makeQualifiedName((String)prefix, (String)ELEM_UNPACK);
            receiver.startElement(namespace, ELEM_UNPACK, qName, attrs);
            receiver.endElement(namespace, ELEM_UNPACK, qName);
        }
    }
}

