/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Reader
extends AbstractCatalogReader {
    public static IArtifactRepository getArtifactRepository(URI repoLocation, IProgressMonitor monitor) throws CoreException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)CorePlugin.getDefault().getResolverAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            IArtifactRepository iArtifactRepository = manager.loadRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        catch (ProvisionException e) {
            IArtifactRepository iArtifactRepository = manager.refreshRepository(repoLocation, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public P2Reader(IReaderType readerType, ProviderMatch providerMatch) {
        super(readerType, providerMatch);
    }

    @Override
    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        IArtifactRepository ar = P2Reader.getArtifactRepository(this.getURI(), monitor);
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(destination.toFile()));
                ar.getArtifact(null, (OutputStream)out, monitor);
            }
            catch (FileNotFoundException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    @Override
    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    @Override
    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        return null;
    }

    URI getURI() {
        ProviderMatch pm = this.getProviderMatch();
        return URI.create(pm.getProvider().getURI(pm.getNodeQuery().getProperties()));
    }
}

