/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.MapUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.ITeamReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.git.internal.GitReader;
import org.eclipse.buckminster.git.internal.Messages;
import org.eclipse.buckminster.git.internal.VersionFinder;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitReaderType
extends CatalogReaderType
implements ITeamReaderType {
    public String convertFetchFactoryLocator(Map<String, Object> fetchFactoryLocator, String componentName) throws CoreException {
        String repo = MapUtils.getString(fetchFactoryLocator, (String)"repo");
        if (repo == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.git_reader_type_is_missing_required_property_0, (Object)"repo"));
        }
        String localClone = "${workspace.root}";
        try {
            URIish tmpURI = new URIish(repo);
            IPath tmpPath = Path.fromPortableString((String)tmpURI.getPath());
            localClone = String.valueOf(localClone) + '/' + tmpPath.lastSegment();
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        String path = MapUtils.getString(fetchFactoryLocator, (String)"path");
        if (path != null) {
            localClone = String.valueOf(localClone) + ',' + path;
        }
        return localClone;
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public Map<String, String> getFetchFactoryProviderProps(Map<String, Object> fetchFactoryLocator, Provider delegee) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("buckminster.source", Boolean.TRUE.toString());
        props.put("buckminster.mutable", Boolean.TRUE.toString());
        String repo = MapUtils.getString(fetchFactoryLocator, (String)"repo");
        if (repo == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.git_reader_type_is_missing_required_property_0, (Object)"repo"));
        }
        props.put("git.remote.uri", repo);
        return props;
    }

    public IPath getInstallLocation(Resolution resolution, MaterializationContext context) throws CoreException {
        File repo;
        String fmt = resolution.getRepository();
        int comma = fmt.lastIndexOf(44);
        if (comma >= 0) {
            fmt = fmt.substring(0, comma);
            repo = new File(fmt);
        } else {
            repo = new File(fmt).getParentFile();
        }
        return Path.fromOSString((String)repo.getAbsolutePath()).addTrailingSeparator();
    }

    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        String workingCopyStr;
        IPath workingCopyPath;
        Logger logger = Buckminster.getLogger();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer resource = wsRoot.getContainerForLocation(workingCopyPath = Path.fromOSString((String)(workingCopyStr = workingCopy.getAbsolutePath())));
        if (resource == null) {
            resource = wsRoot.getFileForLocation(workingCopyPath);
        }
        if (resource == null) {
            try {
                workingCopyStr = workingCopy.getCanonicalPath();
                workingCopyPath = Path.fromOSString((String)workingCopyStr);
                resource = wsRoot.getContainerForLocation(workingCopyPath);
                if (resource == null) {
                    resource = wsRoot.getFileForLocation(workingCopyPath);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (resource == null) {
            logger.debug("getLastModification: Failed get resource for path %s", new Object[]{workingCopy.getAbsolutePath()});
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (provider == null) {
            logger.debug("getLastModification: Unable to get repository provider for project %s", new Object[]{resource.getProject().getName()});
            return null;
        }
        RepositoryMapping rm = RepositoryMapping.getMapping((IResource)resource);
        if (rm == null) {
            logger.debug("getLastModification: Unable to get repository mapping for project %s", new Object[]{resource.getProject().getName()});
            return null;
        }
        Repository repository = rm.getRepository();
        RevWalk walk = new RevWalk(repository);
        try {
            RevCommit rc;
            String gitPath = rm.getRepoRelativePath((IResource)resource);
            if (gitPath == null || gitPath.length() == 0) {
                walk.setTreeFilter(TreeFilter.ANY_DIFF);
            } else {
                walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(gitPath)), (TreeFilter)TreeFilter.ANY_DIFF));
            }
            ObjectId headId = repository.resolve("HEAD");
            if (headId == null) {
                logger.debug("getLastModification: Unable to find head revision in repository %s", new Object[]{repository.getDirectory().getAbsolutePath()});
                return null;
            }
            walk.markStart(walk.parseCommit((AnyObjectId)headId));
            long lastTimestamp = 0L;
            while ((rc = walk.next()) != null) {
                long secondsSinceEpoch = rc.getCommitTime();
                long commitTimestamp = secondsSinceEpoch * 1000L;
                if (commitTimestamp <= lastTimestamp) continue;
                lastTimestamp = commitTimestamp;
            }
            if (lastTimestamp == 0L) {
                logger.debug("getLastModification: Unable to find any file revisions in project %s", new Object[]{resource.getProject().getName()});
                return null;
            }
            Date date = new Date(lastTimestamp);
            return date;
        }
        catch (IOException ex) {
            throw BuckminsterException.wrap((Throwable)ex);
        }
        finally {
            walk.release();
        }
    }

    public IPath getLeafArtifact(Resolution resolution, MaterializationContext context) throws CoreException {
        String fmt = resolution.getRepository();
        int comma = fmt.lastIndexOf(44);
        fmt = comma >= 0 ? fmt.substring(comma + 1) : new File(fmt).getName();
        return Path.fromOSString((String)fmt).addTrailingSeparator();
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new GitReader((IReaderType)this, providerMatch);
    }

    public String getSourceReference(IResource resource, IProgressMonitor monitor) throws CoreException {
        String remoteConfig;
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (!(provider instanceof GitProvider)) {
            return null;
        }
        GitProjectData projectData = ((GitProvider)provider).getData();
        if (projectData == null) {
            return null;
        }
        RepositoryMapping mapping = projectData.getRepositoryMapping(resource);
        if (mapping == null) {
            return null;
        }
        Repository repo = mapping.getRepository();
        if (repo == null) {
            return null;
        }
        StoredConfig config = repo.getConfig();
        Set configNames = config.getSubsections("remote");
        if (configNames.size() == 1) {
            remoteConfig = (String)configNames.iterator().next();
        } else if (configNames.contains("origin")) {
            remoteConfig = "origin";
        } else {
            return null;
        }
        String remoteLocation = config.getString("remote", remoteConfig, "url");
        if (remoteLocation == null) {
            return null;
        }
        return "scm:git:" + remoteLocation;
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new VersionFinder(provider, ctype, nodeQuery);
    }

    public void postMaterialization(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shareProject(IProject project, Resolution cr, RMContext context, IProgressMonitor monitor) throws CoreException {
        String absPath;
        File repoDir = null;
        if (cr.getReaderTypeId().equals("git")) {
            String fmt = cr.getRepository();
            int comma = fmt.lastIndexOf(44);
            if (comma >= 0) {
                fmt = fmt.substring(0, comma);
            }
            repoDir = Path.fromPortableString((String)fmt).append(".git").toFile();
        } else {
            IPath location = project.getLocation();
            while (location.segmentCount() > 0) {
                File dotGit = location.append(".git").toFile();
                if (dotGit.exists()) {
                    repoDir = dotGit;
                    break;
                }
                location = location.removeLastSegments(1);
            }
            if (repoDir == null) {
                return;
            }
        }
        try {
            repoDir = repoDir.getCanonicalFile();
        }
        catch (IOException location) {
            // empty catch block
        }
        String string = absPath = repoDir.getAbsolutePath().intern();
        synchronized (string) {
            Logger logger = Buckminster.getLogger();
            RepositoryUtil repoUtil = Activator.getDefault().getRepositoryUtil();
            if (repoUtil.addConfiguredRepository(repoDir)) {
                logger.info("Added Git repository at %s to the set of known repositories", new Object[]{absPath});
            }
            ConnectProviderOperation connectOp = new ConnectProviderOperation(project, repoDir);
            connectOp.execute(monitor);
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider == null) {
                logger.warning("Failed to get team provider after connecting project %s to Git repository at %s", new Object[]{project.getName(), absPath});
            } else {
                logger.info("Connected project %s to Git repository at %s", new Object[]{project.getName(), absPath});
            }
        }
    }

    public IStatus tag(RepositoryProvider provider, IResource[] resources, String tag, boolean recurse, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }
}

