/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.git.internal.Messages;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryAccess {
    private static final Logger logger = Buckminster.getLogger();
    private static final Object NULL_STRING = "null";
    private final boolean autoFetch;
    private final String component;
    private final File localRepo;
    private final String remoteName;
    private Repository repository;
    private final URIish repoURI;

    private static String getGitTag(VersionMatch versionMatch) {
        String tagName = RepositoryAccess.getTagName(versionMatch);
        if (tagName == null) {
            return null;
        }
        return "refs/tags/" + tagName;
    }

    private static String getTagName(VersionMatch versionMatch) {
        if (versionMatch == null) {
            return null;
        }
        VersionSelector vs = versionMatch.getBranchOrTag();
        if (vs != null && vs.getType() == 1 && !vs.isDefault()) {
            String tagName = vs.getName();
            if (tagName.startsWith("refs/")) {
                tagName = tagName.substring(5);
            }
            if (tagName.startsWith("tags/")) {
                tagName = tagName.substring(5);
            }
            return tagName;
        }
        return null;
    }

    RepositoryAccess(String fmt, Map<String, String> properties) throws CoreException {
        int comma = fmt.lastIndexOf(44);
        if (comma >= 0) {
            this.component = fmt.substring(comma + 1);
            fmt = fmt.substring(0, comma);
        } else {
            this.component = null;
        }
        this.localRepo = new File(fmt, ".git");
        if (!this.localRepo.isAbsolute()) {
            throw BuckminsterException.fromMessage((String)"Git repository path \"%s\" is not absolute", (Object[])new Object[]{fmt});
        }
        String remoteURIStr = properties.get("git.remote.uri");
        if (remoteURIStr != null) {
            try {
                URIish uri;
                String username;
                if (remoteURIStr.startsWith("file:/") && remoteURIStr.length() > 6 && remoteURIStr.charAt(6) != '/') {
                    remoteURIStr = "file:///" + remoteURIStr.substring(6);
                }
                if ((username = (uri = new URIish(remoteURIStr)).getUser()) != null) {
                    String password;
                    if (NULL_STRING.equals(username)) {
                        uri = uri.setUser(null);
                    }
                    if ((password = uri.getPass()) != null && NULL_STRING.equals(password)) {
                        uri = uri.setPass(null);
                    }
                }
                this.repoURI = uri;
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        } else {
            this.repoURI = null;
        }
        fmt = this.localRepo.getAbsolutePath();
        if (!this.localRepo.exists() && this.repoURI == null) {
            throw BuckminsterException.fromMessage((String)"Git repository path \"%s\" does not exist and value is provided for the \"%s\" property", (Object[])new Object[]{fmt, "git.remote.uri"});
        }
        this.autoFetch = Boolean.parseBoolean(properties.get("git.auto.fetch"));
        String tmp = properties.get("git.remote.name");
        if (tmp == null) {
            tmp = "origin";
        }
        this.remoteName = tmp;
    }

    synchronized void close() {
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
    }

    RevCommit getBranchOrTagId(Repository repo, VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        try {
            RevCommit objId = null;
            String revstr = RepositoryAccess.getGitTag(versionMatch);
            if (revstr != null) {
                objId = this.parseCommit(repo.getRef(revstr));
                if (objId == null) {
                    throw BuckminsterException.fromMessage((String)"Unable to obtain ObjectID for tag %s", (Object[])new Object[]{revstr});
                }
                Git git = new Git(repo);
                CheckoutCommand co = git.checkout();
                String tagBranch = "tag-branch_" + RepositoryAccess.getTagName(versionMatch);
                objId = this.parseCommit(repo.getRef(tagBranch));
                if (objId == null) {
                    logger.info("Checking out %s to new branch %s", new Object[]{revstr, tagBranch});
                    co.setCreateBranch(true);
                    co.setName(tagBranch);
                    co.setStartPoint(revstr);
                    return this.parseCommit(co.call());
                }
                RevCommit currentId = this.parseCommit(repo.getRef("HEAD"));
                if (!currentId.equals((AnyObjectId)objId)) {
                    logger.info("Checking out existing branch %s to get tag %s", new Object[]{tagBranch, revstr});
                    co.setCreateBranch(false);
                    co.setName(tagBranch);
                    RevCommit branchCommit = this.parseCommit(co.call());
                    if (!objId.equals((AnyObjectId)branchCommit)) {
                        logger.warning("Branch %s has moved since it was created from %s", new Object[]{tagBranch, revstr});
                    }
                }
                return objId;
            }
            revstr = this.getGitBranch(versionMatch);
            if (revstr == null) {
                revstr = "HEAD";
            }
            if ((objId = this.parseCommit(repo.getRef(revstr))) != null) {
                return objId;
            }
            String remoteBranch = this.getGitRemoteBranch(versionMatch, repo.getBranch());
            objId = this.parseCommit(repo.getRef(remoteBranch));
            if (objId == null) {
                throw BuckminsterException.fromMessage((String)"Unable to obtain ObjectID for branch %s", (Object[])new Object[]{remoteBranch});
            }
            String localBranch = this.getBranchName(versionMatch);
            if (localBranch == null) {
                localBranch = "master";
            }
            logger.info("Creating branch %s to track remote branch %s", new Object[]{localBranch, remoteBranch});
            Git git = new Git(repo);
            CheckoutCommand co = git.checkout();
            co.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
            co.setCreateBranch(true);
            co.setName(localBranch);
            co.setStartPoint(remoteBranch);
            objId = this.parseCommit(co.call());
            StoredConfig config = repo.getConfig();
            config.setString("branch", localBranch, "remote", this.remoteName);
            config.setString("branch", localBranch, "merge", "refs/heads/" + localBranch);
            config.save();
            return objId;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    String getComponent() {
        return this.component;
    }

    File getLocation(VersionMatch versionMatch) throws CoreException {
        File location = this.getRepository(versionMatch, (IProgressMonitor)new NullProgressMonitor()).getWorkTree();
        if (this.component != null) {
            location = new File(location, this.component);
        }
        return location;
    }

    Repository getRepository() throws CoreException {
        String repoPath;
        File canonicalLocalRepo;
        try {
            canonicalLocalRepo = this.localRepo.getCanonicalFile();
        }
        catch (IOException e) {
            canonicalLocalRepo = this.localRepo;
        }
        String string = repoPath = canonicalLocalRepo.getAbsolutePath().intern();
        synchronized (string) {
            if (this.repository != null) {
                return this.repository;
            }
            try {
                boolean infant;
                boolean bl = infant = !canonicalLocalRepo.exists();
                if (infant) {
                    File localDir = canonicalLocalRepo.getParentFile();
                    logger.info("Cloning remote repository %s into %s", new Object[]{this.repoURI.toString(), localDir.getAbsolutePath()});
                    CloneCommand cc = Git.cloneRepository();
                    cc.setBare(false);
                    cc.setDirectory(localDir);
                    cc.setNoCheckout(false);
                    cc.setURI(this.repoURI.toPrivateString());
                    cc.call();
                }
                this.repository = FileRepositoryBuilder.create((File)canonicalLocalRepo);
                RepositoryUtil repoUtil = Activator.getDefault().getRepositoryUtil();
                if (repoUtil.addConfiguredRepository(canonicalLocalRepo)) {
                    logger.info("Added Git repository at %s to the set of known repositories", new Object[]{repoPath});
                }
                return this.repository;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository getRepository(VersionMatch vm, IProgressMonitor monitor) throws CoreException {
        String refStr = RepositoryAccess.getGitTag(vm);
        if (refStr == null) {
            refStr = this.getGitBranch(vm);
        }
        try {
            Repository repo = this.getRepository();
            String string = this.getRepositoryPath();
            synchronized (string) {
                RevCommit wantedId = this.getBranchOrTagId(repo, vm, monitor);
                RevCommit currentId = this.parseCommit(repo.getRef("HEAD"));
                if (refStr == null || wantedId.equals((AnyObjectId)currentId)) {
                    return repo;
                }
                IndexDiff diff = new IndexDiff(repo, refStr, (WorkingTreeIterator)new FileTreeIterator(repo));
                if (!diff.diff()) {
                    return repo;
                }
                if (!(this.component == null || this.scanFiles(diff.getMissing()) || this.scanFiles(diff.getModified()) || this.scanFiles(diff.getUntracked()))) {
                    return repo;
                }
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.git_reader_0_cannot_switch_to_1_without_causing_conflict_beneath_2, (Object[])new Object[]{this.localRepo.getAbsolutePath(), refStr, this.component}), (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    String getRepositoryPath() {
        File canonicalLocalRepo;
        try {
            canonicalLocalRepo = this.localRepo.getCanonicalFile();
        }
        catch (IOException e) {
            canonicalLocalRepo = this.localRepo;
        }
        return canonicalLocalRepo.getAbsolutePath().intern();
    }

    TreeWalk getTreeWalk(Repository repo, ObjectId id, String path, IProgressMonitor monitor) throws CoreException {
        ObjectReader curs = repo.newObjectReader();
        try {
            CanonicalTreeParser p = new CanonicalTreeParser();
            RevWalk revWalk = new RevWalk(curs);
            try {
                p.reset(curs, (AnyObjectId)revWalk.parseTree((AnyObjectId)id));
            }
            finally {
                revWalk.release();
            }
            TreeWalk treeWalk = new TreeWalk(curs);
            treeWalk.setRecursive(true);
            treeWalk.addTree((AbstractTreeIterator)p);
            if (this.component == null) {
                if (path == null) {
                    TreeWalk treeWalk2 = treeWalk;
                    return treeWalk2;
                }
            } else {
                path = String.valueOf(this.component) + (path != null ? String.valueOf('/') + path : "");
            }
            treeWalk.setFilter((TreeFilter)PathFilter.create((String)path));
            TreeWalk treeWalk3 = treeWalk;
            return treeWalk3;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            curs.release();
        }
    }

    TreeWalk getTreeWalk(VersionMatch versionMatch, String path, IProgressMonitor monitor) throws CoreException {
        RevCommit id = this.getBranchOrTagId(this.getRepository(versionMatch, monitor), versionMatch, monitor);
        Repository repo = this.getRepository(versionMatch, monitor);
        return this.getTreeWalk(repo, (ObjectId)id, path, monitor);
    }

    boolean isAutoFetch() {
        return this.autoFetch;
    }

    boolean scanFiles(Set<String> files) {
        if (files == null || files.isEmpty()) {
            return false;
        }
        for (String file : files) {
            if (!file.startsWith(this.component)) continue;
            return true;
        }
        return false;
    }

    private String getBranchName(VersionMatch versionMatch) {
        VersionSelector vs;
        if (versionMatch != null && (vs = versionMatch.getBranchOrTag()) != null && vs.getType() == 0 && !vs.isDefault()) {
            String branchName = vs.getName();
            if (branchName.startsWith("refs/")) {
                branchName = branchName.substring(5);
            }
            if (branchName.startsWith("remotes/")) {
                branchName = branchName.substring(8);
            } else if (branchName.startsWith("heads/")) {
                branchName = branchName.substring(6);
            }
            int rlen = this.remoteName.length();
            if (branchName.length() > rlen && branchName.startsWith(this.remoteName) && branchName.charAt(rlen) == '/') {
                branchName = branchName.substring(rlen + 1);
            }
            return branchName;
        }
        return null;
    }

    private String getGitBranch(VersionMatch versionMatch) {
        String branchName = this.getBranchName(versionMatch);
        return branchName == null ? null : "refs/heads/" + branchName;
    }

    private String getGitRemoteBranch(VersionMatch versionMatch, String currentBranch) {
        String branchName = this.getBranchName(versionMatch);
        String remoteBase = String.valueOf(this.remoteName) + '/';
        if (branchName == null) {
            branchName = currentBranch;
        }
        return String.valueOf(remoteBase) + branchName;
    }

    private RevCommit parseCommit(Ref branch) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (branch == null) {
            return null;
        }
        RevWalk rw = new RevWalk(this.repository);
        try {
            RevCommit revCommit = rw.parseCommit((AnyObjectId)branch.getObjectId());
            return revCommit;
        }
        finally {
            rw.release();
        }
    }
}

