/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.junit.internal;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.buckminster.junit.internal.Messages;
import org.eclipse.buckminster.junit.internal.TestListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ResultSerializer
implements XMLReader {
    private static final String EMPTY = "";
    private static final String CDATA = "CDATA";
    private static final NumberFormat timeFormat = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.US));
    private static final Attributes NO_ATTS = new AttributesImpl();
    private ITestRunSession testRunSession;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private TestListener testListener;
    private IStreamMonitor[] stdOut;
    private IStreamMonitor[] stdErr;
    private boolean terseXML;
    private boolean flatXML;
    private String suiteStack = "";

    public ResultSerializer(TestListener listener, IStreamMonitor[] stdout, IStreamMonitor[] stderr, boolean terseXML, boolean flatXML) {
        if (listener.getTestRunSession() == null) {
            throw new IllegalArgumentException(Messages.ResultSerializer_No_Test_Session);
        }
        this.testListener = listener;
        this.testRunSession = listener.getTestRunSession();
        this.stdOut = stdout;
        this.stdErr = stderr;
        this.terseXML = terseXML;
        this.flatXML = flatXML;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new SAXException("ContentHandler missing");
        }
        this.contentHandler.startDocument();
        this.handleTestRun();
        this.contentHandler.endDocument();
    }

    public void parse(String systemId) throws IOException, SAXException {
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    private void addCDATA(AttributesImpl atts, String name, String value) {
        atts.addAttribute(EMPTY, EMPTY, name, CDATA, value);
    }

    private void addFailure(ITestElement testElement) throws SAXException {
        ITestElement.FailureTrace failureTrace = testElement.getFailureTrace();
        if (failureTrace != null) {
            AttributesImpl failureAtts = new AttributesImpl();
            String failureKind = testElement.getTestResult(false) == ITestElement.Result.ERROR ? "error" : "failure";
            this.startElement(failureKind, failureAtts);
            String expected = failureTrace.getExpected();
            String actual = failureTrace.getActual();
            if (expected != null) {
                this.startElement("expected", NO_ATTS);
                this.contentHandler.characters(expected.toCharArray(), 0, expected.length());
                this.endElement("expected");
            }
            if (actual != null) {
                this.startElement("actual", NO_ATTS);
                this.contentHandler.characters(actual.toCharArray(), 0, actual.length());
                this.endElement("actual");
            }
            String trace = failureTrace.getTrace();
            this.contentHandler.characters(trace.toCharArray(), 0, trace.length());
            this.endElement(failureKind);
        }
    }

    private void endElement(String name) throws SAXException {
        this.contentHandler.endElement(EMPTY, name, name);
    }

    private void handleTestElement(ITestElement testElement) throws SAXException {
        if (testElement instanceof ITestSuiteElement) {
            ITestSuiteElement testSuiteElement = (ITestSuiteElement)testElement;
            if (this.flatXML) {
                this.suiteStack = String.valueOf(this.suiteStack) + testSuiteElement.getSuiteTypeName() + "$";
            } else {
                AttributesImpl atts = new AttributesImpl();
                this.addCDATA(atts, "name", testSuiteElement.getSuiteTypeName());
                if (!Double.isNaN(testSuiteElement.getElapsedTimeInSeconds())) {
                    this.addCDATA(atts, "time", timeFormat.format(testSuiteElement.getElapsedTimeInSeconds()));
                }
                this.startElement("testsuite", atts);
                this.addFailure(testElement);
            }
            ITestElement[] children = testSuiteElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.handleTestElement(children[i]);
                ++i;
            }
            if (this.flatXML) {
                this.suiteStack = this.suiteStack.substring(0, this.suiteStack.lastIndexOf(testSuiteElement.getSuiteTypeName()));
            } else {
                this.endElement("testsuite");
            }
        } else if (testElement instanceof ITestCaseElement) {
            ITestCaseElement testCaseElement = (ITestCaseElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            String testClassName = testCaseElement.getTestClassName();
            if (this.flatXML) {
                testClassName = this.suiteStack.endsWith(String.valueOf(testClassName) + "$") ? this.suiteStack.substring(0, this.suiteStack.length() - 1) : String.valueOf(this.suiteStack) + testClassName;
            }
            this.addCDATA(atts, "name", testCaseElement.getTestMethodName());
            this.addCDATA(atts, "classname", testClassName);
            if (!Double.isNaN(testCaseElement.getElapsedTimeInSeconds())) {
                this.addCDATA(atts, "time", timeFormat.format(testCaseElement.getElapsedTimeInSeconds()));
            }
            if (testCaseElement.getTestResult(false) == ITestElement.Result.IGNORED) {
                this.addCDATA(atts, "ignored", Boolean.TRUE.toString());
            }
            this.startElement("testcase", atts);
            this.addFailure(testElement);
            this.endElement("testcase");
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
    }

    private void handleTestRun() throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        this.addCDATA(atts, "name", this.testRunSession.getTestRunName());
        this.addCDATA(atts, "tests", String.valueOf(this.testListener.getOverallCount()));
        this.addCDATA(atts, "errors", String.valueOf(this.testListener.getErrorCount()));
        this.addCDATA(atts, "failures", String.valueOf(this.testListener.getFailureCount()));
        this.addCDATA(atts, "ignored", String.valueOf(this.testListener.getIgnoreCount()));
        if (!Double.isNaN(this.testRunSession.getElapsedTimeInSeconds())) {
            this.addCDATA(atts, "time", timeFormat.format(this.testRunSession.getElapsedTimeInSeconds()));
        }
        this.startElement(this.flatXML ? "testsuite" : "testsuites", atts);
        ITestElement[] iTestElementArray = this.testRunSession.getChildren();
        int n = iTestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestElement element = iTestElementArray[n2];
            this.handleTestElement(element);
            ++n2;
        }
        if (!this.terseXML) {
            this.writeStdOut();
            this.writeStdErr();
        }
        this.endElement(this.flatXML ? "testsuite" : "testsuites");
    }

    private void startElement(String name, Attributes atts) throws SAXException {
        this.contentHandler.startElement(EMPTY, name, name, atts);
    }

    private void writeStdErr() throws SAXException {
        IStreamMonitor[] iStreamMonitorArray = this.stdErr;
        int n = this.stdErr.length;
        int n2 = 0;
        while (n2 < n) {
            String contents;
            IStreamMonitor sm = iStreamMonitorArray[n2];
            if (sm != null && (contents = sm.getContents()).length() > 0) {
                this.startElement("system-err", NO_ATTS);
                this.contentHandler.characters(contents.toCharArray(), 0, contents.length());
                this.endElement("system-err");
            }
            ++n2;
        }
    }

    private void writeStdOut() throws SAXException {
        IStreamMonitor[] iStreamMonitorArray = this.stdOut;
        int n = this.stdOut.length;
        int n2 = 0;
        while (n2 < n) {
            String contents;
            IStreamMonitor sm = iStreamMonitorArray[n2];
            if (sm != null && (contents = sm.getContents()).length() > 0) {
                this.startElement("system-out", NO_ATTS);
                this.contentHandler.characters(contents.toCharArray(), 0, contents.length());
                this.endElement("system-out");
            }
            ++n2;
        }
    }
}

