/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConflictPolicy implements Enumerator
{
    USE_WORKSPACE(0, "useWorkspace", "USE_WORKSPACE"),
    USE_SCM(1, "useSCM", "USE_SCM"),
    FAIL(2, "fail", "FAIL");

    public static final int USE_WORKSPACE_VALUE = 0;
    public static final int USE_SCM_VALUE = 1;
    public static final int FAIL_VALUE = 2;
    private static final ConflictPolicy[] VALUES_ARRAY;
    public static final List<ConflictPolicy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConflictPolicy[]{USE_WORKSPACE, USE_SCM, FAIL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConflictPolicy get(int value) {
        switch (value) {
            case 0: {
                return USE_WORKSPACE;
            }
            case 1: {
                return USE_SCM;
            }
            case 2: {
                return FAIL;
            }
        }
        return null;
    }

    public static ConflictPolicy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConflictPolicy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConflictPolicy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConflictPolicy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private ConflictPolicy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

