/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static final String METADATA_FOLDER = ".metadata";

    public static IProject[] getValidOpenProjects(Repository repository) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        File parentFile = repository.getWorkTree();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String projectFilePath;
            File projectFile;
            IProject p = iProjectArray[n2];
            IPath projectLocation = p.getLocation();
            if (p.isOpen() && projectLocation != null && (projectFile = new File(projectFilePath = projectLocation.append(".project").toOSString())).exists() && (file = p.getLocation().toFile()).getAbsolutePath().startsWith(parentFile.getAbsolutePath())) {
                result.add(p);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static void refreshValidProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        ProjectUtil.refreshValidProjects(projects, true, monitor);
    }

    public static void refreshValidProjects(IProject[] projects, boolean delete, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(CoreText.ProjectUtil_refreshingProjects, projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                IPath projectLocation = p.getLocation();
                if (projectLocation != null) {
                    String projectFilePath = projectLocation.append(".project").toOSString();
                    File projectFile = new File(projectFilePath);
                    if (projectFile.exists()) {
                        p.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else if (delete) {
                        p.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        ProjectUtil.closeMissingProject(p, projectFile, monitor);
                    }
                    monitor.worked(1);
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    static void closeMissingProject(IProject p, File projectFile, IProgressMonitor monitor) throws CoreException {
        boolean closeFailed;
        block27: {
            if (p.exists() && !p.isOpen()) {
                return;
            }
            closeFailed = false;
            File projectRoot = projectFile.getParentFile();
            if (!projectRoot.isFile()) {
                boolean hasRoot = projectRoot.exists();
                try {
                    try {
                        if (!hasRoot) {
                            FileUtils.mkdirs((File)projectRoot, (boolean)true);
                        }
                        if (projectFile.createNewFile()) {
                            p.close((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            closeFailed = true;
                        }
                    }
                    catch (IOException iOException) {
                        closeFailed = true;
                        try {
                            FileUtils.delete((File)projectFile, (int)6);
                        }
                        catch (IOException iOException2) {
                            closeFailed = true;
                        }
                        if (!hasRoot) {
                            try {
                                FileUtils.delete((File)projectRoot, (int)7);
                            }
                            catch (IOException iOException3) {
                                closeFailed = true;
                            }
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        FileUtils.delete((File)projectFile, (int)6);
                    }
                    catch (IOException iOException) {
                        closeFailed = true;
                    }
                    if (!hasRoot) {
                        try {
                            FileUtils.delete((File)projectRoot, (int)7);
                        }
                        catch (IOException iOException) {
                            closeFailed = true;
                        }
                    }
                    throw throwable;
                }
                try {
                    FileUtils.delete((File)projectFile, (int)6);
                }
                catch (IOException iOException) {
                    closeFailed = true;
                }
                if (!hasRoot) {
                    try {
                        FileUtils.delete((File)projectRoot, (int)7);
                    }
                    catch (IOException iOException) {
                        closeFailed = true;
                    }
                }
            } else {
                closeFailed = true;
            }
        }
        if (closeFailed) {
            p.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    public static void refreshResources(IResource[] resources, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(CoreText.ProjectUtil_refreshing, resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static IProject[] getProjects(Repository repository) {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryMapping mapping;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (mapping = RepositoryMapping.getMapping((IResource)project)) != null && mapping.getRepository() == repository) {
                result.add(project);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IProject[] getProjectsContaining(Repository repository, Collection<String> fileList) throws CoreException {
        LinkedHashSet<IProject> result = new LinkedHashSet<IProject>();
        File workTree = repository.getWorkTree();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = ProjectUtil.getProjectsForContainerMatch(root);
        block0: for (String member : fileList) {
            File file = new File(workTree, member);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                if (ProjectUtil.checkContainerMatch((IContainer)prj, file.getAbsolutePath())) {
                    result.add(prj);
                    continue block0;
                }
                ++n2;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IContainer findProjectOrWorkspaceRoot(File file) {
        IProject[] allProjects;
        String absFile = file.getAbsolutePath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = allProjects = ProjectUtil.getProjectsForContainerMatch(root);
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            if (ProjectUtil.checkContainerMatch((IContainer)prj, absFile)) {
                return prj;
            }
            ++n2;
        }
        if (ProjectUtil.checkContainerMatch((IContainer)root, absFile)) {
            return root;
        }
        return null;
    }

    private static IProject[] getProjectsForContainerMatch(IWorkspaceRoot root) {
        IProject[] allProjects = root.getProjects();
        Arrays.sort(allProjects, new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                IPath l1 = o1.getLocation();
                IPath l2 = o2.getLocation();
                if (l1 != null && l2 != null) {
                    return -l1.toFile().compareTo(l2.toFile());
                }
                if (l1 != null) {
                    return -1;
                }
                if (l2 != null) {
                    return 1;
                }
                return 0;
            }
        });
        return allProjects;
    }

    private static boolean checkContainerMatch(IContainer container, String absFile) {
        IPath location = container.getLocation();
        if (location != null) {
            char sepChar;
            String absPrj = location.toFile().getAbsolutePath();
            if (absPrj.equals(absFile)) {
                return true;
            }
            if (absPrj.length() < absFile.length() && (sepChar = absFile.charAt(absPrj.length())) == File.separatorChar && absFile.startsWith(absPrj)) {
                return true;
            }
        }
        return false;
    }

    public static boolean findProjectFiles(Collection<File> files, File directory, boolean searchNested, IProgressMonitor monitor) {
        return ProjectUtil.findProjectFiles(files, directory, searchNested, null, monitor);
    }

    private static boolean findProjectFiles(Collection<File> files, File directory, boolean searchNested, Set<String> visistedDirs, IProgressMonitor monitor) {
        Set<String> directoriesVisited;
        if (directory == null) {
            return false;
        }
        if (directory.getName().equals(".git") && RepositoryCache.FileKey.isGitRepository((File)directory, (FS)FS.DETECTED)) {
            return false;
        }
        IProgressMonitor pm = monitor;
        if (pm == null) {
            pm = new NullProgressMonitor();
        } else if (pm.isCanceled()) {
            return false;
        }
        pm.subTask(NLS.bind((String)CoreText.ProjectUtil_taskCheckingDirectory, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null || contents.length == 0) {
            return false;
        }
        if (visistedDirs == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                Activator.logError(exception.getLocalizedMessage(), exception);
            }
        } else {
            directoriesVisited = visistedDirs;
        }
        boolean foundProject = false;
        int i = 0;
        while (i < contents.length) {
            File file = contents[i];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                foundProject = true;
            }
            ++i;
        }
        if (foundProject && !searchNested) {
            return true;
        }
        i = 0;
        while (i < contents.length) {
            block18: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block17: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block17;
                            break block18;
                        }
                        catch (IOException exception) {
                            Activator.logError(exception.getLocalizedMessage(), exception);
                        }
                    }
                    ProjectUtil.findProjectFiles(files, contents[i], searchNested, directoriesVisited, pm);
                }
            }
            ++i;
        }
        return true;
    }
}

