/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;

public abstract class AbstractIllegalMethodReference
extends AbstractProblemDetector {
    private Map<MethodKey, IMethodDescriptor> fIllegalMethods = new HashMap<MethodKey, IMethodDescriptor>();
    private Map<IMethodDescriptor, String> fMethodComponents = new HashMap<IMethodDescriptor, String>();

    void addIllegalMethod(IMethodDescriptor method, String componentId) {
        this.fIllegalMethods.put(new MethodKey(method.getEnclosingType().getQualifiedName(), method.getName(), method.getSignature(), true), method);
        this.fMethodComponents.put(method, componentId);
    }

    @Override
    public boolean considerReference(IReference reference) {
        MethodKey key = new MethodKey(reference.getReferencedTypeName(), reference.getReferencedMemberName(), reference.getReferencedSignature(), true);
        if (super.considerReference(reference) && this.fIllegalMethods.containsKey(key)) {
            this.retainReference(reference);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) {
            return false;
        }
        IApiMember method = reference.getResolvedReference();
        String componentId = this.fMethodComponents.get(method.getHandle());
        return this.isReferenceFromComponent(reference, componentId);
    }

    @Override
    protected int getElementType(IReference reference) {
        return 6;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        IApiMethod method = (IApiMethod)reference.getResolvedReference();
        if (method.isConstructor()) {
            return 7;
        }
        return 8;
    }
}

