/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.Validator;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagValidator
extends Validator {
    boolean fScanTags = true;
    boolean fScanAnnotations = true;
    private Set<String> fProcessedAnnotations = new HashSet<String>();

    public TagValidator(ICompilationUnit parent, boolean tags, boolean annotations) {
        this.fCompilationUnit = parent;
        this.fScanTags = tags;
        this.fScanAnnotations = annotations;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        this.fProcessedAnnotations.clear();
        return super.visit(node);
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        this.fProcessedAnnotations.clear();
        return super.visit(node);
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        this.fProcessedAnnotations.clear();
        return super.visit(node);
    }

    public boolean visit(FieldDeclaration node) {
        this.fProcessedAnnotations.clear();
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        this.fProcessedAnnotations.clear();
        return super.visit(node);
    }

    public boolean visit(Javadoc node) {
        if (!this.fScanTags) {
            return false;
        }
        ASTNode parent = node.getParent();
        if (parent != null) {
            List tags = node.tags();
            this.validateTags(parent, tags);
        }
        return false;
    }

    private void validateTags(ASTNode node, List<TagElement> tags) {
        if (tags.size() == 0) {
            return;
        }
        switch (node.getNodeType()) {
            case 55: {
                TypeDeclaration type = (TypeDeclaration)node;
                this.processTypeNode(type, tags);
                break;
            }
            case 71: {
                Validator.Item item = this.getItem();
                Set<String> supported = this.getSupportedTagNames(64, 16);
                HashSet<String> processed = new HashSet<String>();
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if (processed.contains(tagname)) {
                        this.createTagProblem(item.typename, tag, 6, 8, 7, null);
                    } else if (!supported.contains(tagname)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_enum);
                    } else if (!item.visible) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_enum_not_visible);
                    }
                    processed.add(tagname);
                }
                break;
            }
            case 72: {
                Validator.Item item = this.getItem();
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_an_enum_constant);
                }
                break;
            }
            case 81: {
                Validator.Item item = this.getItem();
                Set<String> supported = this.getSupportedTagNames(128, 16);
                HashSet<String> processed = new HashSet<String>();
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    if (processed.contains(tagname)) {
                        this.createTagProblem(item.typename, tag, 6, 8, 7, null);
                    } else if (!supported.contains(tagname)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_annotation);
                    } else if (!item.visible) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_annotation_not_visible);
                    }
                    processed.add(tagname);
                }
                break;
            }
            case 31: {
                MethodDeclaration method = (MethodDeclaration)node;
                this.processMethodNode(method, tags);
                break;
            }
            case 82: {
                Validator.Item item = this.getItem();
                for (TagElement tag : tags) {
                    String tagname = tag.getTagName();
                    if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
                    this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_annotation_method);
                }
                break;
            }
            case 23: {
                FieldDeclaration field = (FieldDeclaration)node;
                this.processFieldNode(field, tags);
                break;
            }
        }
    }

    void processTypeNode(TypeDeclaration type, List<TagElement> tags) {
        HashSet<String> processed = new HashSet<String>();
        Validator.Item item = this.getItem();
        for (TagElement tag : tags) {
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.createTagProblem(item.typename, tag, 6, 8, 7, null);
            } else {
                Set<String> supportedtags = this.getSupportedTagNames(type.isInterface() ? 2 : 1, 16);
                if (!type.isInterface()) {
                    int flags = type.getModifiers();
                    if (!supportedtags.contains(tagname)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_class);
                    } else if (Flags.isPrivate((int)flags)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_private_class);
                    } else if (Flags.isPackageDefault((int)flags)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_package_default_class);
                    } else if (Flags.isAbstract((int)flags) && "@noinstantiate".equals(tagname)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_abstract_class);
                    } else if (Flags.isFinal((int)flags) && "@noextend".equals(tagname)) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_final_class);
                    } else if (!item.visible) {
                        this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_a_class_that_is_not_visible);
                    }
                } else if (!supportedtags.contains(tagname)) {
                    this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_interface);
                } else if (!item.visible) {
                    this.createTagProblem(item.typename, tag, 2, 7, 6, BuilderMessages.TagValidator_an_interface_that_is_not_visible);
                }
            }
            processed.add(tagname);
        }
    }

    void processFieldNode(FieldDeclaration field, List<TagElement> tags) {
        HashSet<String> processed = new HashSet<String>();
        Validator.Item item = this.getItem();
        for (TagElement tag : tags) {
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.createTagProblem(item.typename, tag, 5, 8, 7, null);
            } else {
                int pkind = this.getParentKind((ASTNode)field);
                int flags = field.getModifiers();
                boolean isprivate = Flags.isPrivate((int)flags);
                boolean ispackage = Flags.isPackageDefault((int)flags);
                Set<String> supportedtags = this.getSupportedTagNames(pkind, 8);
                switch (pkind) {
                    case 128: {
                        this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_annotation_field);
                        break;
                    }
                    case 64: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_enum_field);
                            break;
                        }
                        if (isprivate) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_private_enum_field);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_not_visible_enum_field);
                        break;
                    }
                    case 2: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_an_interface_field);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_not_visible_interface_field);
                        break;
                    }
                    case 1: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_field);
                            break;
                        }
                        if (isprivate) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_private_field);
                            break;
                        }
                        if (ispackage) {
                            this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_package_default_field);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 5, 7, 6, BuilderMessages.TagValidator_a_field_that_is_not_visible);
                        break;
                    }
                }
            }
            processed.add(tagname);
        }
    }

    void processMethodNode(MethodDeclaration method, List<TagElement> tags) {
        int pkind = this.getParentKind((ASTNode)method);
        int mods = method.getModifiers();
        boolean isconstructor = method.isConstructor();
        boolean isstatic = Flags.isStatic((int)mods);
        Validator.Item item = this.getItem();
        Set<String> supportedtags = this.getSupportedTagNames(pkind, isconstructor ? 32 : 4);
        HashSet<String> processed = new HashSet<String>();
        for (TagElement tag : tags) {
            String tagname = tag.getTagName();
            if (tagname == null || !JavadocTagManager.ALL_TAGS.contains(tagname)) continue;
            if (processed.contains(tagname)) {
                this.createTagProblem(item.typename, tag, 6, 8, 7, null);
            } else {
                switch (pkind) {
                    case 64: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_enum_method);
                            break;
                        }
                        if (Flags.isPrivate((int)mods)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_private_enum_method);
                            break;
                        }
                        if (Flags.isPackageDefault((int)mods)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_a_package_default_enum);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_not_visible_enum_method);
                        break;
                    }
                    case 2: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_an_interface_method);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 6, 7, 6, BuilderMessages.TagValidator_not_visible_interface_method);
                        break;
                    }
                    case 1: {
                        if (!supportedtags.contains(tagname)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_constructor : BuilderMessages.TagValidator_a_method);
                            break;
                        }
                        if (Flags.isPrivate((int)mods)) {
                            this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_private_constructor : BuilderMessages.TagValidator_private_method);
                            break;
                        }
                        if (Flags.isPackageDefault((int)mods)) {
                            if (isstatic) {
                                this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_static_package_constructor : BuilderMessages.TagValidator_a_static_package_default_method);
                                break;
                            }
                            this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_package_default_constructor : BuilderMessages.TagValidator_a_package_default_method);
                            break;
                        }
                        if ("@nooverride".equals(tagname)) {
                            if (Flags.isFinal((int)mods)) {
                                if (isstatic) {
                                    this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_static_final_constructor : BuilderMessages.TagValidator_a_static_final_method);
                                    break;
                                }
                                this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_final_constructor : BuilderMessages.TagValidator_a_final_method);
                                break;
                            }
                            if (isstatic) {
                                this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_a_static_constructor : BuilderMessages.TagValidator_a_static_method);
                                break;
                            }
                            if (Flags.isFinal((int)this.getParentModifiers((ASTNode)method))) {
                                this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_constructor_in_final_class : BuilderMessages.TagValidator_a_method_in_a_final_class);
                                break;
                            }
                            if (item.visible) break;
                            this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                            break;
                        }
                        if (item.visible) break;
                        this.createTagProblem(item.typename, tag, 6, 7, 6, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                        break;
                    }
                }
            }
            processed.add(tagname);
        }
    }

    Set<String> getSupportedTagNames(int type, int member) {
        IApiJavadocTag[] tags = ApiPlugin.getJavadocTagManager().getTagsForType(type, member);
        if (tags.length > 0) {
            HashSet<String> valid = new HashSet<String>(tags.length, 1.0f);
            int i = 0;
            while (i < tags.length) {
                valid.add(tags[i].getTagName());
                ++i;
            }
            return valid;
        }
        return Collections.EMPTY_SET;
    }

    private void createTagProblem(String typeName, TagElement tag, int element, int kind, int markerid, String context) {
        int charstart = tag.getStartPosition();
        int charend = charstart + tag.getTagName().length();
        int linenumber = -1;
        try {
            IDocument document = Util.getDocument(this.fCompilationUnit);
            linenumber = document.getLineOfOffset(charstart);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        try {
            IApiProblem problem = ApiProblemFactory.newApiProblem(this.fCompilationUnit.getCorrespondingResource().getProjectRelativePath().toPortableString(), typeName, new String[]{tag.getTagName(), context}, new String[]{"apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{new Integer(markerid), this.fCompilationUnit.getHandleIdentifier()}, linenumber, charstart, charend, 0x20000000, element, kind, 0);
            this.addProblem(problem);
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean visit(MarkerAnnotation node) {
        String name = node.getTypeName().getFullyQualifiedName();
        if (JavadocTagManager.ALL_ANNOTATIONS.contains(name)) {
            ASTNode parent = node.getParent();
            switch (parent.getNodeType()) {
                case 55: {
                    this.checkType(node, (TypeDeclaration)node.getParent());
                    break;
                }
                case 71: {
                    this.checkEnum(node, (EnumDeclaration)parent);
                    break;
                }
                case 72: {
                    Validator.Item item = this.getItem();
                    this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_an_enum_constant);
                    break;
                }
                case 81: {
                    this.checkAnnotation(node, (AnnotationTypeDeclaration)parent);
                    break;
                }
                case 82: {
                    Validator.Item item = this.getItem();
                    this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_an_annotation_method);
                    break;
                }
                case 23: {
                    this.checkField(node, (FieldDeclaration)parent);
                    break;
                }
                case 31: {
                    this.checkMethod(node, (MethodDeclaration)parent);
                    break;
                }
            }
        }
        return false;
    }

    void checkType(MarkerAnnotation node, TypeDeclaration type) {
        String name = node.getTypeName().getFullyQualifiedName();
        Validator.Item item = this.getItem();
        if (this.fProcessedAnnotations.contains(name)) {
            this.createAnnotationProblem(item.typename, node, 2, 12, 10, null);
        } else if (type.isInterface()) {
            Set<String> supported = ApiPlugin.getJavadocTagManager().getAnntationsForType(2, 16);
            if (!supported.contains(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_an_interface);
            } else if (!item.visible) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_an_interface_that_is_not_visible);
            }
        } else {
            int flags = type.getModifiers();
            Set<String> supported = ApiPlugin.getJavadocTagManager().getAnntationsForType(1, 16);
            if (!supported.contains(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_a_class);
            } else if (Flags.isPrivate((int)flags)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_a_private_class);
            } else if (Flags.isPackageDefault((int)flags)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_a_package_default_class);
            } else if (Flags.isAbstract((int)flags) && "NoInstantiate".equals(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_an_abstract_class);
            } else if (Flags.isFinal((int)flags) && "NoExtend".equals(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_a_final_class);
            } else if (!item.visible) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_a_class_that_is_not_visible);
            }
        }
        this.fProcessedAnnotations.add(name);
    }

    void checkEnum(MarkerAnnotation node, EnumDeclaration type) {
        String name = node.getTypeName().getFullyQualifiedName();
        Validator.Item item = this.getItem();
        if (this.fProcessedAnnotations.contains(name)) {
            this.createAnnotationProblem(item.typename, node, 2, 12, 10, null);
        } else {
            Set<String> supported = ApiPlugin.getJavadocTagManager().getAnntationsForType(64, 16);
            if (!supported.contains(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_an_enum);
            } else if (!item.visible) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_enum_not_visible);
            }
        }
        this.fProcessedAnnotations.add(name);
    }

    void checkAnnotation(MarkerAnnotation node, AnnotationTypeDeclaration type) {
        String name = node.getTypeName().getFullyQualifiedName();
        Validator.Item item = this.getItem();
        if (this.fProcessedAnnotations.contains(name)) {
            this.createAnnotationProblem(item.typename, node, 2, 12, 10, null);
        } else {
            Set<String> supported = ApiPlugin.getJavadocTagManager().getAnntationsForType(128, 16);
            if (!supported.contains(name)) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_an_annotation);
            } else if (!item.visible) {
                this.createAnnotationProblem(item.typename, node, 2, 13, 11, BuilderMessages.TagValidator_annotation_not_visible);
            }
        }
    }

    void checkField(MarkerAnnotation node, FieldDeclaration parent) {
        String name = node.getTypeName().getFullyQualifiedName();
        Validator.Item item = this.getItem();
        if (this.fProcessedAnnotations.contains(name)) {
            this.createAnnotationProblem(item.typename, node, 5, 12, 10, null);
        } else {
            int pkind = this.getParentKind((ASTNode)parent);
            int flags = parent.getModifiers();
            boolean isprivate = Flags.isPrivate((int)flags);
            boolean ispackage = Flags.isPackageDefault((int)flags);
            Set<String> supportedtags = ApiPlugin.getJavadocTagManager().getAnntationsForType(pkind, 8);
            switch (pkind) {
                case 128: {
                    this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_annotation_field);
                    break;
                }
                case 64: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_enum_field);
                        break;
                    }
                    if (isprivate) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_private_enum_field);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_not_visible_enum_field);
                    break;
                }
                case 2: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_an_interface_field);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_not_visible_interface_field);
                    break;
                }
                case 1: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_a_field);
                        break;
                    }
                    if (isprivate) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_private_field);
                        break;
                    }
                    if (ispackage) {
                        this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_a_package_default_field);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 5, 13, 11, BuilderMessages.TagValidator_a_field_that_is_not_visible);
                    break;
                }
            }
            this.fProcessedAnnotations.add(name);
        }
    }

    void checkMethod(MarkerAnnotation node, MethodDeclaration parent) {
        String name = node.getTypeName().getFullyQualifiedName();
        int pkind = this.getParentKind((ASTNode)parent);
        int flags = parent.getModifiers();
        boolean isconstructor = parent.isConstructor();
        boolean isstatic = Flags.isStatic((int)flags);
        Validator.Item item = this.getItem();
        Set<String> supportedtags = ApiPlugin.getJavadocTagManager().getAnntationsForType(pkind, isconstructor ? 32 : 4);
        if (this.fProcessedAnnotations.contains(name)) {
            this.createAnnotationProblem(item.typename, node, 6, 12, 10, null);
        } else {
            switch (pkind) {
                case 64: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_an_enum_method);
                        break;
                    }
                    if (Flags.isPrivate((int)flags)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_private_enum_method);
                        break;
                    }
                    if (Flags.isPackageDefault((int)flags)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_a_package_default_enum);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_not_visible_enum_method);
                    break;
                }
                case 2: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_an_interface_method);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 6, 13, 11, BuilderMessages.TagValidator_not_visible_interface_method);
                    break;
                }
                case 1: {
                    if (!supportedtags.contains(name)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_a_constructor : BuilderMessages.TagValidator_a_method);
                        break;
                    }
                    if (Flags.isPrivate((int)flags)) {
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_private_constructor : BuilderMessages.TagValidator_private_method);
                        break;
                    }
                    if (Flags.isPackageDefault((int)flags)) {
                        if (isstatic) {
                            this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_static_package_constructor : BuilderMessages.TagValidator_a_static_package_default_method);
                            break;
                        }
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_a_package_default_constructor : BuilderMessages.TagValidator_a_package_default_method);
                        break;
                    }
                    if ("@nooverride".equals(name)) {
                        if (Flags.isFinal((int)flags)) {
                            if (isstatic) {
                                this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_static_final_constructor : BuilderMessages.TagValidator_a_static_final_method);
                                break;
                            }
                            this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_final_constructor : BuilderMessages.TagValidator_a_final_method);
                            break;
                        }
                        if (isstatic) {
                            this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_a_static_constructor : BuilderMessages.TagValidator_a_static_method);
                            break;
                        }
                        if (Flags.isFinal((int)this.getParentModifiers((ASTNode)parent))) {
                            this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_constructor_in_final_class : BuilderMessages.TagValidator_a_method_in_a_final_class);
                            break;
                        }
                        if (item.visible) break;
                        this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                        break;
                    }
                    if (item.visible) break;
                    this.createAnnotationProblem(item.typename, node, 6, 13, 11, isconstructor ? BuilderMessages.TagValidator_not_visible_constructor : BuilderMessages.TagValidator_a_method_that_is_not_visible);
                    break;
                }
            }
        }
        this.fProcessedAnnotations.add(name);
    }

    void createAnnotationProblem(String typeName, MarkerAnnotation node, int element, int kind, int markerid, String context) {
        String name = String.valueOf('@') + node.getTypeName().getFullyQualifiedName();
        int charstart = node.getStartPosition();
        int charend = charstart + name.length();
        int linenumber = -1;
        try {
            IDocument document = Util.getDocument(this.fCompilationUnit);
            linenumber = document.getLineOfOffset(charstart);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            IApiProblem problem = ApiProblemFactory.newApiProblem(this.fCompilationUnit.getCorrespondingResource().getProjectRelativePath().toPortableString(), typeName, new String[]{name, context}, new String[]{"apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{new Integer(markerid), this.fCompilationUnit.getHandleIdentifier()}, linenumber, charstart, charend, 0x20000000, element, kind, 0);
            this.addProblem(problem);
        }
        catch (JavaModelException javaModelException) {}
    }
}

