/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.core;

import com.mountainminds.eclemma.core.EclEmmaStatus;
import com.mountainminds.eclemma.core.IExecutionDataSource;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public class AgentExecutionDataSource
implements IExecutionDataSource {
    private String address;
    private int port;
    private boolean reset;

    public AgentExecutionDataSource(String address, int port, boolean reset) {
        this.address = address;
        this.port = port;
        this.reset = reset;
    }

    public void accept(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoVisitor) throws CoreException {
        try {
            Socket socket = new Socket(this.address, this.port);
            RemoteControlWriter writer = new RemoteControlWriter(socket.getOutputStream());
            RemoteControlReader reader = new RemoteControlReader(socket.getInputStream());
            reader.setExecutionDataVisitor(executionDataVisitor);
            reader.setSessionInfoVisitor(sessionInfoVisitor);
            writer.visitDumpCommand(true, this.reset);
            reader.read();
            socket.close();
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.AGENT_CONNECT_ERROR.getStatus(this.address, this.port, e));
        }
    }
}

