/*
 * Decompiled with CFR 0.152.
 */
package com.mountainminds.eclemma.internal.core.analysis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jacoco.core.analysis.Analyzer;

class ResourceTreeWalker {
    private final Analyzer analyzer;

    public ResourceTreeWalker(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void walk(IResource resource) throws CoreException, IOException {
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            InputStream in = file.getContents(true);
            try {
                this.analyzer.analyzeAll(in, resource.getName());
            }
            finally {
                in.close();
            }
        } else {
            this.walkResource(resource, true);
        }
    }

    private void walkResource(IResource resource, boolean root) throws CoreException, IOException {
        switch (resource.getType()) {
            case 1: {
                if (!resource.getName().endsWith(".class")) break;
                IFile file = (IFile)resource;
                InputStream in = file.getContents(true);
                try {
                    this.analyzer.analyzeAll(in, resource.getName());
                    break;
                }
                finally {
                    in.close();
                }
            }
            case 2: 
            case 4: {
                if (!root && !this.isJavaIdentifier(resource.getName())) break;
                IContainer container = (IContainer)resource;
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.walkResource(child, false);
                    ++n2;
                }
                break;
            }
        }
    }

    public void walk(IPath path) throws IOException {
        File file = path.toFile();
        if (file.isFile()) {
            InputStream in = this.open(file);
            try {
                this.analyzer.analyzeAll(in, path.toString());
            }
            finally {
                in.close();
            }
        } else {
            this.walkFile(file, true);
        }
    }

    private void walkFile(File file, boolean root) throws IOException {
        if (file.isFile()) {
            if (file.getName().endsWith(".class")) {
                InputStream in = this.open(file);
                try {
                    this.analyzer.analyzeAll(in, file.toString());
                }
                finally {
                    in.close();
                }
            }
        } else if (root || this.isJavaIdentifier(file.getName())) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.walkFile(child, false);
                ++n2;
            }
        }
    }

    private InputStream open(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    private boolean isJavaIdentifier(String name) {
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

