/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ImportProxySettings
extends WorkspaceCommand {
    private Map<String, AbstractProxySettingsImporter> buildProxySettingsImportersMap(AbstractProxySettingsImporter ... proxySettingsImporters) {
        HashMap<String, AbstractProxySettingsImporter> proxySettingsImportersMap = new HashMap<String, AbstractProxySettingsImporter>();
        boolean hasSavedProxyProperties = false;
        AbstractProxySettingsImporter[] abstractProxySettingsImporterArray = proxySettingsImporters;
        int n = proxySettingsImporters.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractProxySettingsImporter proxySettingsImporter = abstractProxySettingsImporterArray[n2];
            proxySettingsImportersMap.put(proxySettingsImporter.getProxyType(), proxySettingsImporter);
            hasSavedProxyProperties |= proxySettingsImporter.hasSavedProxyProperties();
            ++n2;
        }
        return hasSavedProxyProperties ? proxySettingsImportersMap : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        Iterator<AbstractProxySettingsImporter> iterator;
        Map<String, AbstractProxySettingsImporter> proxySettingsImportersMap = this.buildProxySettingsImportersMap(new HttpProxySettingsImporter(), new HttpsProxySettingsImporter(), new SocksProxySettingsImporter());
        if (proxySettingsImportersMap == null) {
            Buckminster.getLogger().warning(Messages.No_proxy_settings_to_import, new Object[0]);
            return 0;
        }
        try {
            DirectProxiesSuspender proxiesSuspender;
            block24: {
                IProxyService proxyService;
                ServiceReference proxyServiceReference;
                BundleContext bundleContext;
                proxiesSuspender = new DirectProxiesSuspender();
                try {
                    Throwable t;
                    bundleContext = CorePlugin.getDefault().getBundle().getBundleContext();
                    try {
                        proxyServiceReference = bundleContext.getServiceReference(IProxyService.class);
                        proxyService = (IProxyService)bundleContext.getService(proxyServiceReference);
                        t = null;
                    }
                    catch (Exception e) {
                        proxyServiceReference = null;
                        proxyService = null;
                        t = e;
                    }
                    catch (NoClassDefFoundError e) {
                        proxyServiceReference = null;
                        proxyService = null;
                        t = e;
                    }
                    if (t != null) {
                        Buckminster.getLogger().warning(t, Messages.Platform_proxy_API_not_available, new Object[0]);
                        proxiesSuspender.restoreProxies();
                    }
                }
                catch (Throwable throwable) {
                    proxiesSuspender.restoreProxies();
                    throw throwable;
                }
                {
                    if (proxyService != null) {
                        try {
                            AbstractProxySettingsImporter proxySettingsImporter;
                            IProxyData proxyDatum;
                            IProxyData[] proxyData = proxyService.getProxyData();
                            LinkedHashSet<String> nonProxiedHosts = new LinkedHashSet<String>();
                            boolean settingsImported = false;
                            IProxyData[] iProxyDataArray = proxyData;
                            int n = proxyData.length;
                            int n2 = 0;
                            while (n2 < n) {
                                proxyDatum = iProxyDataArray[n2];
                                proxySettingsImporter = proxySettingsImportersMap.get(proxyDatum.getType());
                                if (proxySettingsImporter != null) {
                                    settingsImported |= proxySettingsImporter.importProxySettings(proxyDatum, nonProxiedHosts);
                                }
                                ++n2;
                            }
                            if (!nonProxiedHosts.isEmpty()) {
                                proxyService.setNonProxiedHosts(nonProxiedHosts.toArray(new String[nonProxiedHosts.size()]));
                            }
                            if (!settingsImported) break block24;
                            proxyService.setSystemProxiesEnabled(false);
                            proxyService.setProxyData(proxyData);
                            iProxyDataArray = proxyData;
                            n = proxyData.length;
                            n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    proxiesSuspender.ensureRestoreEnablesProxies();
                                    break block24;
                                }
                                proxyDatum = iProxyDataArray[n2];
                                proxySettingsImporter = proxySettingsImportersMap.get(proxyDatum.getType());
                                if (proxySettingsImporter != null) {
                                    proxySettingsImporter.setProxySettingsSystemProperties(proxyDatum);
                                }
                                ++n2;
                            }
                        }
                        finally {
                            bundleContext.ungetService(proxyServiceReference);
                        }
                    }
                    Buckminster.getLogger().warning(Messages.Platform_proxy_service_not_registered, new Object[0]);
                }
            }
            proxiesSuspender.restoreProxies();
        }
        finally {
            iterator = proxySettingsImportersMap.values().iterator();
        }
        while (iterator.hasNext()) {
            AbstractProxySettingsImporter proxySettingsImporter = iterator.next();
            proxySettingsImporter.restoreProxySettingsSystemProperties();
        }
        return 0;
    }

    protected static abstract class AbstractHttpProxySettingsImporter
    extends AbstractProxySettingsImporter {
        private StringBuilder propertiesPrefix;
        private int prefixLength;

        protected AbstractHttpProxySettingsImporter() {
        }

        protected String getPrefixedPropetyName(String propertyName) {
            this.propertiesPrefix.setLength(this.prefixLength);
            return this.propertiesPrefix.append(propertyName).toString();
        }

        protected void importNonProxiedHostsSetting(String nonProxiedHostsPropertyName, Set<String> nonProxiedHosts) {
            String nonProxiedHostsString = this.savedProxyProperties.getProperty(nonProxiedHostsPropertyName);
            if (nonProxiedHostsString == null) {
                return;
            }
            String[] stringArray = nonProxiedHostsString.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nonProxiedHost = stringArray[n2];
                if ((nonProxiedHost = nonProxiedHost.trim()).length() > 0) {
                    nonProxiedHosts.add(nonProxiedHost);
                }
                ++n2;
            }
        }

        @Override
        public boolean importProxySettings(IProxyData proxyDatum, Set<String> nonProxiedHosts) {
            this.importNonProxiedHostsSetting(this.getPrefixedPropetyName("nonProxyHosts"), nonProxiedHosts);
            String proxyHost = this.savedProxyProperties.getProperty(this.getPrefixedPropetyName("proxyHost"));
            if (proxyHost == null || (proxyHost = proxyHost.trim()).length() == 0) {
                return false;
            }
            proxyDatum.setHost(proxyHost);
            this.importProxyPortSetting(this.getPrefixedPropetyName("proxyPort"), proxyDatum);
            String proxyUser = this.savedProxyProperties.getProperty(this.getPrefixedPropetyName("proxyUser"));
            if (proxyUser == null) {
                proxyUser = this.savedProxyProperties.getProperty(this.getPrefixedPropetyName("proxyUserName"));
            }
            if (proxyUser != null) {
                proxyDatum.setUserid(proxyUser);
                String proxyPassword = this.savedProxyProperties.getProperty(this.getPrefixedPropetyName("proxyPassword"));
                if (proxyPassword != null) {
                    proxyDatum.setPassword(proxyPassword);
                }
            }
            return true;
        }

        @Override
        protected void init() {
            this.propertiesPrefix = new StringBuilder(this.getProxyType().toLowerCase());
            this.propertiesPrefix.append('.');
            this.prefixLength = this.propertiesPrefix.length();
        }

        @Override
        protected void saveProxySettingsSystemProperties() {
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxySet"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxyHost"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxyPort"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("nonProxyHosts"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxyUser"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxyUserName"));
            this.saveProxySystemProperty(this.getPrefixedPropetyName("proxyPassword"));
        }

        @Override
        protected void setProxySettingsSystemPropertiesImpl(IProxyData proxyDatum) {
            Properties systemProperties = System.getProperties();
            String proxyHost = proxyDatum.getHost();
            if (proxyHost != null) {
                systemProperties.setProperty(this.getPrefixedPropetyName("proxySet"), Boolean.TRUE.toString());
                systemProperties.setProperty(this.getPrefixedPropetyName("proxyHost"), proxyHost);
            } else {
                systemProperties.remove(this.getPrefixedPropetyName("proxySet"));
                systemProperties.remove(this.getPrefixedPropetyName("proxyHost"));
            }
            this.setProxyPortSystemProperty(this.getPrefixedPropetyName("proxyPort"), proxyDatum);
        }
    }

    protected static abstract class AbstractProxySettingsImporter {
        protected Properties savedProxyProperties = new Properties();

        public AbstractProxySettingsImporter() {
            this.init();
            this.saveProxySettingsSystemProperties();
        }

        public abstract String getProxyType();

        public boolean hasSavedProxyProperties() {
            return !this.savedProxyProperties.isEmpty();
        }

        protected void importProxyPortSetting(String proxyPortPropertyName, IProxyData proxyDatum) {
            String proxyPortString = this.savedProxyProperties.getProperty(proxyPortPropertyName);
            if (proxyPortString != null) {
                try {
                    proxyDatum.setPort(Integer.parseInt(proxyPortString));
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            proxyDatum.setPort(-1);
        }

        public abstract boolean importProxySettings(IProxyData var1, Set<String> var2);

        protected void init() {
        }

        public void restoreProxySettingsSystemProperties() {
            System.getProperties().putAll((Map<?, ?>)this.savedProxyProperties);
            this.savedProxyProperties.clear();
        }

        protected abstract void saveProxySettingsSystemProperties();

        protected void saveProxySystemProperty(String proxyPropertyName) {
            Properties systemProperties = System.getProperties();
            String proxyPropertyValue = systemProperties.getProperty(proxyPropertyName);
            if (proxyPropertyValue == null) {
                return;
            }
            systemProperties.remove(proxyPropertyName);
            this.savedProxyProperties.setProperty(proxyPropertyName, proxyPropertyValue);
        }

        protected void setProxyPortSystemProperty(String proxyPortPropertyName, IProxyData proxyDatum) {
            int proxyPort = proxyDatum.getPort();
            if (proxyPort != -1) {
                System.getProperties().setProperty(proxyPortPropertyName, Integer.toString(proxyPort));
            } else {
                System.getProperties().remove(proxyPortPropertyName);
            }
        }

        public void setProxySettingsSystemProperties(IProxyData proxyDatum) {
            this.setProxySettingsSystemPropertiesImpl(proxyDatum);
            this.savedProxyProperties.clear();
        }

        protected abstract void setProxySettingsSystemPropertiesImpl(IProxyData var1);
    }

    protected static class DirectProxiesSuspender {
        public static final String PREF_ENABLED = "proxiesEnabled";
        protected IEclipsePreferences proxyPreferencesScope = ConfigurationScope.INSTANCE.getNode("org.eclipse.core.net");
        protected Boolean proxiesEnabled = this.getBoolean("proxiesEnabled");

        public DirectProxiesSuspender() {
            this.putBoolean(PREF_ENABLED, Boolean.FALSE);
        }

        public void ensureRestoreEnablesProxies() {
            this.proxiesEnabled = Boolean.TRUE;
        }

        protected Boolean getBoolean(String key) {
            String valueString = this.proxyPreferencesScope.node("").get(key, null);
            return valueString == null ? null : Boolean.valueOf(valueString);
        }

        protected void putBoolean(String key, Boolean value) {
            if (value != null) {
                this.proxyPreferencesScope.node("").put(key, value.toString());
            } else {
                this.proxyPreferencesScope.node("").remove(key);
            }
        }

        public void restoreProxies() {
            if (this.proxiesEnabled != Boolean.FALSE) {
                this.putBoolean(PREF_ENABLED, this.proxiesEnabled);
                this.proxiesEnabled = Boolean.FALSE;
            }
        }
    }

    protected static class HttpProxySettingsImporter
    extends AbstractHttpProxySettingsImporter {
        protected HttpProxySettingsImporter() {
        }

        @Override
        public String getProxyType() {
            return "HTTP";
        }
    }

    protected static class HttpsProxySettingsImporter
    extends AbstractHttpProxySettingsImporter {
        protected HttpsProxySettingsImporter() {
        }

        @Override
        public String getProxyType() {
            return "HTTPS";
        }
    }

    protected static class SocksProxySettingsImporter
    extends AbstractProxySettingsImporter {
        protected SocksProxySettingsImporter() {
        }

        @Override
        public String getProxyType() {
            return "SOCKS";
        }

        @Override
        public boolean importProxySettings(IProxyData proxyDatum, Set<String> nonProxiedHosts) {
            String proxyHost = this.savedProxyProperties.getProperty("socksProxyHost");
            if (proxyHost == null) {
                return false;
            }
            proxyDatum.setHost(proxyHost);
            this.importProxyPortSetting("socksProxyPort", proxyDatum);
            return true;
        }

        @Override
        protected void saveProxySettingsSystemProperties() {
            this.saveProxySystemProperty("socksProxyHost");
            this.saveProxySystemProperty("socksProxyPort");
        }

        @Override
        protected void setProxySettingsSystemPropertiesImpl(IProxyData proxyDatum) {
            String proxyHost = proxyDatum.getHost();
            if (proxyHost != null) {
                System.getProperties().setProperty("socksProxyHost", proxyHost);
            } else {
                System.getProperties().remove("socksProxyHost");
            }
            this.setProxyPortSystemProperty("socksProxyPort", proxyDatum);
        }
    }
}

