/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class Launch
extends WorkspaceCommand {
    private static final OptionDescriptor LAUNCH_DESCRIPTOR = new OptionDescriptor('l', "launch", 3);
    private static final OptionDescriptor STDOUT_DESCRIPTOR = new OptionDescriptor(null, "stdout", 2);
    private static final OptionDescriptor STDERR_DESCRIPTOR = new OptionDescriptor(null, "stderr", 2);
    private String launchName;
    private String stdOutFile;
    private String stdErrFile;
    private IStreamMonitor[] stdOut;
    private IStreamMonitor[] stdErr;
    private List<StreamListener> listeners = new ArrayList<StreamListener>();
    private ILaunch launch;
    private boolean background = false;

    public String getLaunchName() {
        return this.launchName;
    }

    public IStreamMonitor[] getRawStdErr() {
        return (IStreamMonitor[])this.stdErr.clone();
    }

    public IStreamMonitor[] getRawStdOut() {
        return (IStreamMonitor[])this.stdOut.clone();
    }

    public String getStdErr() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.stdErr;
        int n = this.stdErr.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor err = iStreamMonitorArray[n2];
            if (err != null) {
                content.append(err.getContents());
            }
            ++n2;
        }
        return content.toString();
    }

    public String getStdOut() {
        StringBuffer content = new StringBuffer();
        IStreamMonitor[] iStreamMonitorArray = this.stdOut;
        int n = this.stdOut.length;
        int n2 = 0;
        while (n2 < n) {
            IStreamMonitor out = iStreamMonitorArray[n2];
            if (out != null) {
                content.append(out.getContents());
            }
            ++n2;
        }
        return content.toString();
    }

    public void setBackground(boolean flag) {
        this.background = flag;
    }

    protected String getLaunchMode() {
        return "run";
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(LAUNCH_DESCRIPTOR);
        appendHere.add(STDOUT_DESCRIPTOR);
        appendHere.add(STDERR_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(LAUNCH_DESCRIPTOR)) {
            this.launchName = option.getValue();
        } else if (option.is(STDOUT_DESCRIPTOR)) {
            this.stdOutFile = option.getValue() == null ? "-" : option.getValue();
        } else if (option.is(STDERR_DESCRIPTOR)) {
            this.stdErrFile = option.getValue() == null ? "-" : option.getValue();
        } else {
            super.handleOption(option);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final class StreamListener
    implements IStreamListener {
        private PrintStream stream;

        public StreamListener(IStreamMonitor monitor, String outputFile, boolean stdout) {
            Launch.this.listeners.add(this);
            if ("-".equals(outputFile)) {
                this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
            } else {
                try {
                    this.stream = new PrintStream(outputFile);
                }
                catch (FileNotFoundException e) {
                    CorePlugin.getLogger().error((Throwable)e, Messages.Launch_Cannot_open_stream, new Object[]{outputFile});
                    this.stream = stdout ? Logger.getOutStream() : Logger.getErrStream();
                }
            }
            this.stream.print(monitor.getContents());
            monitor.addListener((IStreamListener)this);
        }

        public void close() {
            if (this.stream != Logger.getOutStream() && this.stream != Logger.getErrStream()) {
                this.stream.close();
            }
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.stream.print(text);
            if (monitor instanceof IFlushableStreamMonitor) {
                IFlushableStreamMonitor flushableMonitor = (IFlushableStreamMonitor)monitor;
                flushableMonitor.flushContents();
            }
        }
    }
}

