/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.IPerformManager;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class Perform
extends WorkspaceCommand {
    private static final OptionDescriptor FORCED_DESCRIPTOR = new OptionDescriptor('F', "force", 1);
    private static final OptionDescriptor QUIET_DESCRIPTOR = new OptionDescriptor('Q', "quiet", 1);
    private static final OptionDescriptor MAXWARNINGS_DESCRIPTOR = new OptionDescriptor('W', "maxWarnings", 3);
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private boolean forced = false;
    private int maxWarnings = -1;
    private boolean quiet;

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(MAXWARNINGS_DESCRIPTOR);
        appendHere.add(FORCED_DESCRIPTOR);
        appendHere.add(QUIET_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(MAXWARNINGS_DESCRIPTOR)) {
            this.maxWarnings = Integer.parseInt(option.getValue());
        } else if (option.is(FORCED_DESCRIPTOR)) {
            this.forced = true;
        } else if (option.is(QUIET_DESCRIPTOR)) {
            this.quiet = true;
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        String[] stringArray = unparsed;
        int n = unparsed.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String component = null;
            String attribute = null;
            int splitIdx = s.lastIndexOf(35);
            if (splitIdx > 0) {
                attribute = s.substring(splitIdx + 1).trim();
                if (attribute.length() == 0) {
                    attribute = null;
                }
                if ((component = s.substring(0, splitIdx).trim()).length() == 0) {
                    component = null;
                }
            }
            if (component == null || attribute == null) {
                throw new UsageException(Messages.Attribute_names_must_be_in_the_form_component_name_attribute_name);
            }
            CSpec cspec = WorkspaceInfo.getResolution(ComponentIdentifier.parse(component)).getCSpec();
            this.addAttribute(cspec.getRequiredAttribute(attribute));
            ++n2;
        }
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        if (this.attributes.isEmpty()) {
            throw new UsageException(Messages.No_attributes_specified);
        }
        IPerformManager pm = CorePlugin.getPerformManager();
        IStatus status = pm.perform(this.attributes, null, this.forced, this.quiet, monitor).getStatus();
        if (status.isOK()) {
            return 0;
        }
        IMarker[] markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (markers.length == 0) {
            return 0;
        }
        if (this.isQuiet()) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker problem = iMarkerArray[n2];
                if (problem.getAttribute("severity", 0) == 2) {
                    return 1;
                }
                ++n2;
            }
            return 0;
        }
        TreeMap<Long, IMarker> problems = new TreeMap<Long, IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n3 = 0;
        while (n3 < n) {
            IMarker problem = iMarkerArray[n3];
            problems.put(problem.getCreationTime(), problem);
            ++n3;
        }
        int warnings = 0;
        int errors = 0;
        int exitValue = 0;
        for (IMarker problem : problems.values()) {
            switch (problem.getAttribute("severity", 0)) {
                case 2: {
                    exitValue = 1;
                    ++errors;
                    System.err.println(this.formatMarkerMessage("Error", problem));
                    break;
                }
                case 1: {
                    ++warnings;
                    System.err.println(this.formatMarkerMessage("Warning", problem));
                    break;
                }
                case 0: {
                    System.out.println(this.formatMarkerMessage("Info", problem));
                }
            }
        }
        if (warnings + errors > 0) {
            StringBuilder bld = new StringBuilder();
            bld.append(Messages.Found);
            if (errors > 0) {
                bld.append(errors);
                bld.append(Messages.Errors);
                if (warnings > 0) {
                    bld.append(Messages.And);
                }
            }
            if (warnings > 0) {
                bld.append(warnings);
                bld.append(Messages.Warnings);
            }
            System.err.println(bld.toString());
        }
        if (this.maxWarnings != -1 && warnings > this.maxWarnings) {
            System.err.println(Messages.Too_many_warnings_Exiting_with_error_status);
            exitValue = 1;
        }
        if (exitValue > 0) {
            System.err.println(Messages.Build_failed);
        }
        return exitValue;
    }

    private String formatMarkerMessage(String type, IMarker problem) {
        StringBuilder bld = new StringBuilder();
        bld.append(type);
        bld.append(": file ");
        bld.append(problem.getResource().getLocation().toOSString());
        int line = problem.getAttribute("lineNumber", -1);
        if (line > 0) {
            bld.append(", line ");
            bld.append(line);
        }
        bld.append(": ");
        bld.append(problem.getAttribute("message", ""));
        return bld.toString();
    }
}

