/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.commands;

import java.util.List;
import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.cmdline.Option;
import org.eclipse.buckminster.cmdline.OptionDescriptor;
import org.eclipse.buckminster.cmdline.UsageException;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.commands.PreferenceMappingManager;
import org.eclipse.buckminster.core.commands.WorkspaceCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class UnsetPreference
extends WorkspaceCommand {
    private static final OptionDescriptor TEST_DESCRIPTOR = new OptionDescriptor(null, "__test", 1);
    private boolean test = false;
    private String[] assignments;

    protected void getOptionDescriptors(List<OptionDescriptor> appendHere) throws Exception {
        appendHere.add(TEST_DESCRIPTOR);
        super.getOptionDescriptors(appendHere);
    }

    protected void handleOption(Option option) throws Exception {
        if (option.is(TEST_DESCRIPTOR)) {
            this.test = true;
        } else {
            super.handleOption(option);
        }
    }

    protected void handleUnparsed(String[] unparsed) throws Exception {
        if (unparsed.length < 1) {
            throw new UsageException(Messages.You_must_provide_at_least_one_preference_to_unset);
        }
        this.assignments = unparsed;
    }

    @Override
    protected int internalRun(IProgressMonitor monitor) throws Exception {
        PreferenceMappingManager prefManager = PreferenceMappingManager.getInstance(this.test);
        int idx = 0;
        while (idx < this.assignments.length) {
            String assignment = this.assignments[idx];
            BasicPreferenceHandler bph = prefManager.getHandler(assignment);
            bph.unset();
            System.out.println(NLS.bind((String)Messages.Unset_the_value_for_0, (Object)bph.getName()));
            ++idx;
        }
        return 0;
    }
}

