/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.common.model;

import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.RxPart;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.helpers.AttributesImpl;

public class RxPattern
extends RxPart {
    public static final String TAG = "match";
    public static final String ATTR_PATTERN = "pattern";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_SUFFIX = "suffix";
    private final String pattern;
    private final String prefix;
    private final String suffix;

    private static void addEscapedPattern(StringBuilder bld, String pattern, boolean willBeGroup) throws CoreException {
        int orDepth = -1;
        int startPos = bld.length();
        int parenDepth = 0;
        boolean inCharGroup = false;
        boolean stripOuter = false;
        int top = pattern.length();
        int idx = 0;
        while (idx < top) {
            int c = pattern.charAt(idx++);
            switch (c) {
                case 92: {
                    bld.append((char)c);
                    if (idx >= top) break;
                    c = pattern.charAt(idx++);
                    break;
                }
                case 124: {
                    if (orDepth != -1 && orDepth <= parenDepth) break;
                    orDepth = parenDepth;
                    break;
                }
                case 91: {
                    inCharGroup = true;
                    break;
                }
                case 93: {
                    inCharGroup = false;
                    break;
                }
                case 40: {
                    if (inCharGroup) break;
                    ++parenDepth;
                    if (idx == top) break;
                    if (pattern.charAt(idx) != '?') {
                        if (idx == 1) {
                            stripOuter = true;
                        }
                        bld.append("(?");
                        c = 58;
                        break;
                    }
                    if (idx != 1 || top <= 2) break;
                    stripOuter = pattern.charAt(2) == ':';
                    break;
                }
                case 41: {
                    if (inCharGroup || --parenDepth < 0 || parenDepth != 0 || idx >= top) break;
                    stripOuter = false;
                }
            }
            bld.append((char)c);
        }
        if (parenDepth != 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.Unbalanced_parenthesis_in_pattern_0, (Object)pattern), (Object[])new Object[0]);
        }
        if (stripOuter) {
            if (willBeGroup || orDepth != 1) {
                int tpos = startPos;
                int fpos = startPos + 3;
                int epos = bld.length() - 1;
                while (fpos < epos) {
                    bld.setCharAt(tpos++, bld.charAt(fpos++));
                }
                bld.setLength(tpos);
            }
        } else if (!willBeGroup && orDepth == 0) {
            String subExpr = bld.substring(startPos, bld.length());
            bld.setLength(startPos);
            bld.append("(?:");
            bld.append(subExpr);
            bld.append(')');
        }
    }

    private static void addQuotedString(StringBuilder bld, String str) throws CoreException {
        int top = str.length();
        int idx = 0;
        while (idx < top) {
            char c = str.charAt(idx);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    bld.append('\\');
                }
            }
            bld.append(c);
            ++idx;
        }
    }

    public RxPattern(String name, boolean optional, String pattern, String prefix, String suffix) {
        super(name, optional);
        this.pattern = pattern;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public void addPattern(StringBuilder bld, List<RxPart> namedParts) throws CoreException {
        if (!this.isOptional()) {
            this.addInnerPattern(bld, namedParts, false);
            return;
        }
        bld.append('(');
        if (this.prefix == null && this.suffix == null) {
            String name = this.getName();
            if (name == null) {
                bld.append("?:");
            } else {
                namedParts.add(this);
            }
            RxPattern.addEscapedPattern(bld, this.pattern, true);
        } else {
            bld.append("?:");
            this.addInnerPattern(bld, namedParts, true);
        }
        bld.append(")?");
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PATTERN, (String)this.pattern);
        if (this.prefix != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_PREFIX, (String)this.prefix);
        }
        if (this.suffix != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SUFFIX, (String)this.suffix);
        }
    }

    private void addInnerPattern(StringBuilder bld, List<RxPart> namedParts, boolean willBeGroup) throws CoreException {
        String name;
        if (this.prefix != null) {
            RxPattern.addQuotedString(bld, this.prefix);
        }
        if ((name = this.getName()) != null) {
            bld.append('(');
            RxPattern.addEscapedPattern(bld, this.pattern, true);
            bld.append(')');
            namedParts.add(this);
        } else {
            RxPattern.addEscapedPattern(bld, this.pattern, willBeGroup && this.prefix == null && this.suffix == null);
        }
        if (this.suffix != null) {
            RxPattern.addQuotedString(bld, this.suffix);
        }
    }
}

