/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class ComponentRequestBuilder
implements IComponentRequest {
    private String name;
    private String componentType;
    private VersionRange versionRange;
    private Filter filter;

    public void clear() {
        this.name = null;
        this.componentType = null;
        this.versionRange = null;
        this.filter = null;
    }

    public ComponentRequest createComponentRequest() {
        return new ComponentRequest(this);
    }

    @Override
    public boolean designates(IComponentIdentifier id) {
        return !(!Trivial.equalsAllowNull((Object)this.getName(), (Object)id.getName()) || this.componentType != null && !this.componentType.equals(id.getComponentTypeID()) || this.versionRange != null && !this.versionRange.isIncluded(id.getVersion()));
    }

    @Override
    public String getComponentTypeID() {
        return this.componentType;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public void initFrom(IComponentRequest request) {
        this.name = request.getName();
        this.componentType = request.getComponentTypeID();
        this.versionRange = request.getVersionRange();
        this.filter = request.getFilter();
    }

    public void setComponentTypeID(String componentType) {
        this.componentType = componentType;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }
}

