/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.builder;

import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.PrerequisiteAlreadyDefinedException;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.equinox.p2.metadata.VersionRange;

public abstract class TopLevelAttributeBuilder
extends AttributeBuilder {
    private boolean publ = false;

    TopLevelAttributeBuilder(CSpecBuilder cspecBuilder) {
        super(cspecBuilder);
    }

    public final PrerequisiteBuilder addExternalPrerequisite(IComponentRequest request, String attr) throws PrerequisiteAlreadyDefinedException {
        return this.addPrerequisite(this.createPrerequisite(request.getName(), request.getComponentTypeID(), request.getVersionRange(), attr, null, null));
    }

    public final PrerequisiteBuilder addLocalPrerequisite(AttributeBuilder attr) throws PrerequisiteAlreadyDefinedException {
        return this.addLocalPrerequisite(attr.getName());
    }

    public final PrerequisiteBuilder addLocalPrerequisite(String attr) throws PrerequisiteAlreadyDefinedException {
        return this.addPrerequisite(this.createPrerequisite(null, null, null, attr, null, null));
    }

    public final PrerequisiteBuilder addLocalPrerequisite(String attr, String alias) throws PrerequisiteAlreadyDefinedException {
        return this.addPrerequisite(this.createPrerequisite(null, null, null, attr, alias, null));
    }

    public final PrerequisiteBuilder addLocalPrerequisite(String attr, String alias, Filter filter) throws PrerequisiteAlreadyDefinedException {
        return this.addPrerequisite(this.createPrerequisite(null, null, null, attr, alias, filter));
    }

    public PrerequisiteBuilder addPrerequisite(PrerequisiteBuilder prerequisite) throws PrerequisiteAlreadyDefinedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.publ = false;
    }

    @Override
    public abstract Attribute createAttribute();

    public PrerequisiteBuilder createPrerequisiteBuilder() {
        return new PrerequisiteBuilder(this);
    }

    @Override
    public void initFrom(IAttribute attribute) {
        super.initFrom(attribute);
        this.publ = attribute.isPublic();
    }

    @Override
    public boolean isPublic() {
        return this.publ;
    }

    public void removePrerequisite(IPrerequisite pq) {
        this.removePrerequisite(pq.toString());
    }

    public void removePrerequisite(String prerequisiteName) {
        throw new UnsupportedOperationException();
    }

    public void setPublic(boolean flag) {
        this.publ = flag;
    }

    private PrerequisiteBuilder createPrerequisite(String component, String type, VersionRange versionRange, String name, String alias, Filter filter) {
        PrerequisiteBuilder bld = this.createPrerequisiteBuilder();
        bld.setComponentName(component);
        bld.setComponentType(type);
        bld.setVersionRange(versionRange);
        bld.setName(name);
        bld.setAlias(alias);
        bld.setFilter(filter);
        return bld;
    }
}

