/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.NamedElement;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Prerequisite
extends NamedElement
implements IPrerequisite {
    public static final String ATTR_ALIAS = "alias";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_COMPONENT_TYPE = "componentType";
    public static final String ATTR_CONTRIBUTOR = "contributor";
    public static final String ATTR_EXCLUDE_PATTERN = "excludePattern";
    public static final String ATTR_INCLUDE_PATTERN = "includePattern";
    public static final String ATTR_FILTER = "filter";
    public static final String TAG = "attribute";
    private final String alias;
    private final String componentName;
    private final String componentType;
    private final VersionRange versionRange;
    private final boolean contributor;
    private final Pattern excludePattern;
    private final Pattern includePattern;
    private final Filter filter;

    public static boolean isMatch(String component, String attribute, Pattern excludePattern, Pattern includePattern) {
        Matcher m;
        CharSequence tmp;
        if (attribute == null && component == null) {
            return false;
        }
        if (excludePattern == null && includePattern == null) {
            return true;
        }
        if (attribute == null) {
            tmp = component;
        } else {
            StringBuilder bld = new StringBuilder();
            if (component != null) {
                bld.append(component);
            }
            bld.append('#');
            bld.append(attribute);
            tmp = bld;
        }
        if (excludePattern != null && (m = excludePattern.matcher(tmp)).matches()) {
            return false;
        }
        return includePattern == null || (m = includePattern.matcher(tmp)).matches();
    }

    public Prerequisite(PrerequisiteBuilder bld) {
        super(bld.getName());
        this.alias = bld.getAlias();
        this.contributor = bld.isContributor();
        this.componentName = bld.getComponentName();
        this.componentType = bld.getComponentType();
        this.versionRange = bld.getVersionRange();
        this.excludePattern = bld.getExcludePattern();
        this.includePattern = bld.getIncludePattern();
        this.filter = bld.getFilter();
    }

    @Override
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final String getAttribute() {
        return this.getName();
    }

    @Override
    public final String getComponentName() {
        return this.componentName;
    }

    @Override
    public final String getComponentType() {
        return this.componentType;
    }

    public String getDefaultTag() {
        return TAG;
    }

    @Override
    public Pattern getExcludePattern() {
        return this.excludePattern;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Pattern getIncludePattern() {
        return this.includePattern;
    }

    public Attribute getReferencedAttribute(CSpec ownerCSpec, IModelCache ctx) throws CoreException {
        return this.filter == null || this.filter.matches(ctx.getProperties()) ? ownerCSpec.getReferencedAttribute(this.componentName, this.componentType, this.versionRange, this.getName(), ctx) : null;
    }

    public CSpec getReferencedCSpec(CSpec ownerCSpec, IModelCache ctx) throws CoreException {
        return this.filter == null || this.filter.matches(ctx.getProperties()) ? ownerCSpec.getReferencedCSpec(this.componentName, this.componentType, this.versionRange, ctx) : null;
    }

    @Override
    public final VersionRange getVersionRange() {
        return this.versionRange;
    }

    @Override
    public boolean isContributor() {
        return this.contributor;
    }

    public boolean isEnabled(IModelCache cache, CSpec cspec) throws CoreException {
        if (this.filter != null && !this.filter.matches(cache.getProperties())) {
            return false;
        }
        if (this.isExternal()) {
            try {
                return this.getReferencedAttribute(cspec, cache) != null;
            }
            catch (MissingComponentException e) {
                return true;
            }
        }
        return cspec.getAttribute(this.getAttribute()).isEnabled(cache);
    }

    @Override
    public boolean isExternal() {
        return this.componentName != null;
    }

    @Override
    public boolean isMatch(String component, String attribute) {
        return Prerequisite.isMatch(component, attribute, this.excludePattern, this.includePattern);
    }

    public boolean isPatternFilter() {
        return this.excludePattern != null || this.includePattern != null;
    }

    @Override
    public String toString() {
        if (this.componentName == null) {
            return this.getName();
        }
        StringBuilder bld = new StringBuilder();
        bld.append(this.componentName);
        if (this.componentType != null) {
            bld.append(':');
            bld.append(this.componentType);
        }
        bld.append('#');
        bld.append(this.getName());
        if (this.versionRange != null) {
            bld.append('/');
            bld.append(VersionHelper.getHumanReadable(this.versionRange));
        }
        return bld.toString();
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) {
        super.addAttributes(attrs);
        if (this.alias != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALIAS, (String)this.alias);
        }
        if (!this.contributor) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_CONTRIBUTOR, (String)"false");
        }
        if (this.excludePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_EXCLUDE_PATTERN, (String)this.excludePattern.toString());
        }
        if (this.includePattern != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_INCLUDE_PATTERN, (String)this.includePattern.toString());
        }
        if (this.componentName != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT, (String)this.componentName);
        }
        if (this.componentType != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPE, (String)this.componentType);
        }
        if (this.versionRange != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"versionDesignator", (String)this.versionRange.toString());
        }
        if (this.filter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FILTER, (String)this.filter.toString());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
    }
}

