/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.cspec.parser;

import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.parser.AttributeHandler;
import org.eclipse.buckminster.core.cspec.parser.ICSpecBuilderSupport;
import org.eclipse.buckminster.core.cspec.parser.TopLevelAttributeHandler;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

abstract class AttributesHandler
extends ExtensionAwareHandler
implements ChildPoppedListener,
ICSpecBuilderSupport {
    private TopLevelAttributeHandler publicHandler;
    private TopLevelAttributeHandler privateHandler;

    AttributesHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) throws SAXException {
        this.addAttribute(((AttributeHandler)child).getAttributeBuilder());
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        TopLevelAttributeHandler ch;
        if ("public".equals(localName)) {
            if (this.publicHandler == null) {
                this.publicHandler = this.createAttributeHandler(true);
            }
            ch = this.publicHandler;
        } else if ("private".equals(localName)) {
            if (this.privateHandler == null) {
                this.privateHandler = this.createAttributeHandler(false);
            }
            ch = this.privateHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    @Override
    public CSpecBuilder getCSpecBuilder() {
        return ((ICSpecBuilderSupport)this.getParentHandler()).getCSpecBuilder();
    }

    final void addAttribute(AttributeBuilder attribute) throws SAXException {
        try {
            this.getCSpecBuilder().addAttribute(attribute);
        }
        catch (AttributeAlreadyDefinedException e) {
            throw new SAXParseException(e.getMessage(), this.getDocumentLocator());
        }
    }

    abstract TopLevelAttributeHandler createAttributeHandler(boolean var1);
}

