/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ProgressStatistics {
    public static final AmountConverter TRIVIAL_CONVERTER = new TrivialConverter();
    public static final AmountConverter FILESIZE_CONVERTER = new FileSizeConverter();
    public static final int DEFAULT_REPORT_INTERVAL = 1000;
    public static final int DEFAULT_RECENT_SPEED_INTERVAL = 5000;
    public static final int DEFULAT_RECENT_SPEED_RESOLUTION = 1000;
    private long current = 0L;
    private long total = -1L;
    private Date startTime = new Date();
    private AmountConverter converter = TRIVIAL_CONVERTER;
    private Date lastReportTime = null;
    private int reportInterval = 1000;
    private int recentSpeedInterval = 5000;
    private int recentSpeedResolution = 1000;
    private SortedMap<Long, Long> recentSpeedMap = new TreeMap<Long, Long>();
    private long recentSpeedMapKey = 0L;

    public ProgressStatistics() {
    }

    public ProgressStatistics(long total) {
        this();
        this.total = total;
    }

    public long getAverageSpeed() {
        long dur = this.getDuration();
        if (dur >= 1000L) {
            return this.current / (dur / 1000L);
        }
        return 0L;
    }

    public long getDuration() {
        return new Date().getTime() - this.startTime.getTime();
    }

    public double getPercentage() {
        if (this.total > 0L) {
            return (double)this.current / (double)this.total;
        }
        return 0.0;
    }

    public synchronized long getRecentSpeed() {
        this.removeObsoleteRecentSpeedData(this.getDuration() / (long)this.recentSpeedResolution);
        long dur = 0L;
        long amount = 0L;
        SortedMap<Long, Long> relevantData = this.recentSpeedMap.headMap(this.recentSpeedMapKey);
        for (Map.Entry<Long, Long> entry : relevantData.entrySet()) {
            dur += (long)this.recentSpeedResolution;
            amount += entry.getValue().longValue();
        }
        if (dur >= 1000L) {
            return amount / (dur / 1000L);
        }
        return 0L;
    }

    public int getRecentSpeedInterval() {
        return this.recentSpeedInterval;
    }

    public int getRecentSpeedResolution() {
        return this.recentSpeedResolution;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public void increase(long inc) {
        this.registerRecentSpeed(this.getDuration() / (long)this.recentSpeedResolution, inc);
        this.current += inc;
    }

    public String report() {
        return String.valueOf(this.converter.convert(this.current)) + (this.total != -1L ? " of " + this.converter.convert(this.total) : "") + " at " + this.converter.convert(this.getRecentSpeed()) + "/s";
    }

    public void setConverter(AmountConverter converter) {
        if (converter == null) {
            converter = TRIVIAL_CONVERTER;
        }
        this.converter = converter;
    }

    public void setRecentSpeedInterval(int recentSpeedInterval) {
        if (recentSpeedInterval <= 0) {
            recentSpeedInterval = 5000;
        }
        this.recentSpeedInterval = recentSpeedInterval;
    }

    public void setRecentSpeedResolution(int recentSpeedResolution) {
        if (recentSpeedResolution <= 0) {
            recentSpeedResolution = 1000;
        }
        this.recentSpeedResolution = recentSpeedResolution;
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public boolean shouldReport() {
        Date now = new Date();
        if (this.lastReportTime == null || now.getTime() - this.lastReportTime.getTime() >= (long)this.reportInterval) {
            this.lastReportTime = now;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.report();
    }

    private synchronized void registerRecentSpeed(long key, long inc) {
        Long keyL = key;
        Long currentValueL = (Long)this.recentSpeedMap.get(keyL);
        long currentValue = 0L;
        if (currentValueL != null) {
            currentValue = currentValueL;
        }
        this.recentSpeedMap.put(keyL, inc + currentValue);
        if (this.recentSpeedMapKey != key) {
            this.recentSpeedMapKey = key;
            this.removeObsoleteRecentSpeedData(key);
        }
    }

    private synchronized void removeObsoleteRecentSpeedData(long lastKey) {
        long threshold = lastKey - (long)(this.recentSpeedInterval / this.recentSpeedResolution);
        this.recentSpeedMap.headMap(threshold).clear();
    }

    public static interface AmountConverter {
        public String convert(long var1);
    }

    static class FileSizeConverter
    implements AmountConverter {
        FileSizeConverter() {
        }

        @Override
        public String convert(long amount) {
            if (amount < 1024L) {
                return String.format(Locale.US, "%dB", amount);
            }
            if (amount < 0x100000L) {
                return String.format(Locale.US, "%.2fkB", (double)amount / 1024.0);
            }
            return String.format(Locale.US, "%.2fMB", (double)amount / 1048576.0);
        }
    }

    static class TrivialConverter
    implements AmountConverter {
        TrivialConverter() {
        }

        @Override
        public String convert(long amount) {
            return "" + amount;
        }
    }
}

