/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.helpers;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.buckminster.core.common.model.IExpandingMap;

public class UnmodifiableMapUnion<K, V>
extends AbstractMap<K, V>
implements IExpandingMap<K, V> {
    private final Map<? extends K, ? extends V> map;
    private final Map<? extends K, ? extends V> overlay;

    public UnmodifiableMapUnion(Map<? extends K, ? extends V> overlay, Map<? extends K, ? extends V> map) {
        this.overlay = overlay;
        this.map = map;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.overlay.containsKey(key) || this.map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.get(key, this);
    }

    @Override
    public V get(Object key, Map<K, V> expansionScope) {
        V value = this.overlay instanceof IExpandingMap ? ((IExpandingMap)((Object)this.overlay)).get(key, expansionScope) : this.overlay.get(key);
        if (value == null && !this.overlay.containsKey(key)) {
            value = this.map instanceof IExpandingMap ? ((IExpandingMap)((Object)this.map)).get(key, expansionScope) : this.map.get(key);
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    public Set<? extends K> overlayKeySet() {
        return this.overlay.keySet();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int immutableVisibleCount = 0;
        for (K key : this.map.keySet()) {
            if (this.overlay.containsKey(key)) continue;
            ++immutableVisibleCount;
        }
        return this.overlay.size() + immutableVisibleCount;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return UnmodifiableMapUnion.this.size();
            }
        };
    }

    abstract class AbstractIterator<X>
    implements Iterator<X> {
        private Iterator<? extends K> currentIterator;
        private K currentKey;
        private boolean phase1;

        AbstractIterator() {
            this.currentIterator = UnmodifiableMapUnion.this.overlay.keySet().iterator();
            this.currentKey = null;
            this.phase1 = true;
        }

        @Override
        public boolean hasNext() {
            this.currentKey = this.getValidKey();
            return this.currentKey != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        K nextKey() {
            Object key = this.getValidKey();
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.currentKey = null;
            return key;
        }

        private K getValidKey() {
            if (this.currentKey != null) {
                return this.currentKey;
            }
            if (this.phase1) {
                if (this.currentIterator.hasNext()) {
                    this.currentKey = this.currentIterator.next();
                    return this.currentKey;
                }
                this.currentIterator = UnmodifiableMapUnion.this.map.keySet().iterator();
                this.phase1 = false;
            }
            while (this.currentIterator.hasNext()) {
                Object key = this.currentIterator.next();
                if (UnmodifiableMapUnion.this.overlay.containsKey(key)) continue;
                this.currentKey = key;
                break;
            }
            return this.currentKey;
        }
    }

    class EntryIterator
    extends AbstractIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnionEntry(this.nextKey());
        }
    }

    class KeyIterator
    extends AbstractIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextKey();
        }
    }

    class UnionEntry
    implements Map.Entry<K, V> {
        private final K key;

        public UnionEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return UnmodifiableMapUnion.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    class ValueIterator
    extends AbstractIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return UnmodifiableMapUnion.this.get(this.nextKey());
        }
    }
}

