/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.URLCatalogReader;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.core.security.IConnectContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class URLCatalogReaderType
extends CatalogReaderType {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static final Pattern htmlPattern = Pattern.compile("<A\\s+HREF=\"([^?][^:\"]+)\"\\s*>[^<]+</A>", 2);
    private static final Pattern ftpPattern = Pattern.compile("[a-z]+\\s+[0-9]+\\s+(?:(?:[0-9]+:[0-9]+)|(?:[0-9]{4}))\\s+(.+?)(?:([\\r|\\n])|(\\s+->\\s+))", 2);
    private static final Pattern indexPath = Pattern.compile("^(.*/)?index\\.[a-z][a-z0-9]+$");
    private static final ThreadLocal<ProviderMatch> currentProviderMatch = new InheritableThreadLocal<ProviderMatch>();

    static {
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(false);
    }

    /*
     * Unable to fully structure code
     */
    public static URL[] extractHTMLLinks(URL urlToHTML, IConnectContext cctx, IProgressMonitor monitor) throws CoreException {
        block8: {
            links = new ArrayList<URL>();
            try {
                buffer = new AccessibleByteArrayOutputStream(8192, 0x200000);
                DownloadManager.readInto((URL)urlToHTML, (IConnectContext)cctx, (OutputStream)buffer, (IProgressMonitor)monitor);
                try {
                    builder = URLCatalogReaderType.documentBuilderFactory.newDocumentBuilder();
                    builder.setErrorHandler(new ErrorHandler(){

                        @Override
                        public void error(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        @Override
                        public void fatalError(SAXParseException ex) throws SAXException {
                            throw ex;
                        }

                        @Override
                        public void warning(SAXParseException ex) throws SAXException {
                        }
                    });
                    source = new InputSource(buffer.getInputStream());
                    source.setSystemId(urlToHTML.toString());
                    document = builder.parse(source);
                    URLCatalogReaderType.collectLinks(document.getDocumentElement(), urlToHTML, links);
                    break block8;
                }
                catch (SAXException e) {
                    scanner = new Scanner(buffer.getInputStream());
                    parent = URLUtils.appendTrailingSlash((URL)urlToHTML);
                    ** while (scanner.findWithinHorizon((Pattern)URLCatalogReaderType.htmlPattern, (int)0) != null)
                }
lbl-1000:
                // 1 sources

                {
                    mr = scanner.match();
                    URLCatalogReaderType.addLink(links, parent, mr.group(1));
                    continue;
                }
lbl21:
                // 1 sources

                scanner.close();
            }
            catch (IllegalStateException e) {
                CorePlugin.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return Trivial.EMPTY_URL_ARRAY;
            }
            catch (FileNotFoundException e) {
                return Trivial.EMPTY_URL_ARRAY;
            }
            catch (IOException e) {
                CorePlugin.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return Trivial.EMPTY_URL_ARRAY;
            }
            catch (ParserConfigurationException e) {
                CorePlugin.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                return Trivial.EMPTY_URL_ARRAY;
            }
        }
        return links.toArray(new URL[links.size()]);
    }

    public static ProviderMatch getCurrentProviderMatch() {
        return currentProviderMatch.get();
    }

    public static IComponentReader getReader(URL catalog, IProgressMonitor monitor) throws CoreException {
        return URLCatalogReaderType.getDirectReader(catalog, "url.catalog", monitor);
    }

    public static URL[] list(URL url, IConnectContext cctx, IProgressMonitor monitor) throws CoreException {
        File dir = FileUtils.getFile(url);
        if (dir != null) {
            File[] list = dir.listFiles();
            if (list == null) {
                return Trivial.EMPTY_URL_ARRAY;
            }
            int top = list.length;
            if (top == 0) {
                return Trivial.EMPTY_URL_ARRAY;
            }
            URL[] result = new URL[top];
            while (--top >= 0) {
                File file = list[top];
                URI uri = URLUtils.normalizeToURI((String)file.toString(), (boolean)file.isDirectory());
                try {
                    result[top] = uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            MonitorUtils.complete((IProgressMonitor)monitor);
            return result;
        }
        String proto = url.getProtocol();
        if (proto.equalsIgnoreCase("ftp") || proto.equalsIgnoreCase("sftp")) {
            ArrayList<URL> result = new ArrayList<URL>();
            try (Scanner scanner = null;){
                scanner = new Scanner(DownloadManager.read((URL)url, (IConnectContext)cctx));
                url = URLUtils.appendTrailingSlash((URL)url);
                while (scanner.findWithinHorizon(ftpPattern, 0) != null) {
                    MatchResult mr = scanner.match();
                    result.add(new URL(url, mr.group(1)));
                }
                URL[] uRLArray = result.toArray(new URL[result.size()]);
                return uRLArray;
            }
        }
        return URLCatalogReaderType.extractHTMLLinks(url, cctx, monitor);
    }

    static IComponentReader getDirectReader(URL url, String readerType, IProgressMonitor monitor) throws CoreException {
        String urlString = url.toString();
        ComponentRequest rq = new ComponentRequest(urlString, null, null);
        ComponentQueryBuilder queryBld = new ComponentQueryBuilder();
        queryBld.setRootRequest(rq);
        queryBld.setPlatformAgnostic(true);
        ResolutionContext context = new ResolutionContext(queryBld.createComponentQuery());
        NodeQuery nq = new NodeQuery(context, rq, null);
        IComponentType ctype = CorePlugin.getDefault().getComponentType("unknown");
        Provider provider = Provider.immutableProvider(readerType, ctype.getId(), urlString);
        ProviderMatch pm = new ProviderMatch(provider, ctype, VersionMatch.DEFAULT, ProviderScore.GOOD, nq);
        return pm.getReader(monitor);
    }

    private static void addLink(List<URL> links, URL parent, String link) throws MalformedURLException {
        Matcher m = indexPath.matcher(link.toString());
        if (m.matches() && (link = m.group(1)) == null) {
            return;
        }
        if (link.equals("../")) {
            return;
        }
        links.add(new URL(parent, link));
    }

    private static void collectLinks(Element element, URL parent, ArrayList<URL> links) {
        if (element.getNodeName().equals("a")) {
            try {
                URLCatalogReaderType.addLink(links, parent, element.getAttribute("href"));
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            Node child = element.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    URLCatalogReaderType.collectLinks((Element)child, parent, links);
                }
                child = child.getNextSibling();
            }
        }
    }

    @Override
    public URL convertToURL(String repositoryLocator, VersionMatch versionSelector) throws CoreException {
        try {
            return URLUtils.normalizeToURL((String)repositoryLocator);
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        try {
            return new URI(resolution.getRepository());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Date getLastModification(File workingCopy, IProgressMonitor monitor) throws CoreException {
        IPath workingCopyPath;
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IContainer resource = wsRoot.getContainerForLocation(workingCopyPath = Path.fromOSString((String)workingCopy.getAbsolutePath()));
        if (resource == null && (resource = wsRoot.getFileForLocation(workingCopyPath)) == null) {
            return null;
        }
        LastModficationTimeFinder timeFinder = new LastModficationTimeFinder();
        resource.accept((IResourceVisitor)timeFinder);
        return timeFinder.getTimestamp();
    }

    public IReaderType getLocalReaderType() {
        return this;
    }

    @Override
    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new URLCatalogReader(this, providerMatch);
    }

    @Override
    public String getRemotePath(String repositoryLocation) throws CoreException {
        return this.getURI(repositoryLocation).getPath();
    }

    public URI getURI(Provider provider, Map<String, ? extends Object> properties) throws CoreException {
        return this.getURI(provider.getURI(properties));
    }

    public URI getURI(ProviderMatch providerMatch) throws CoreException {
        return this.getURI(providerMatch.getRepositoryURI());
    }

    public URI getURI(String repository) throws CoreException {
        return URLUtils.normalizeToURI((String)repository, (boolean)true);
    }

    private class LastModficationTimeFinder
    implements IResourceVisitor {
        long timestamp = -1L;

        private LastModficationTimeFinder() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.isDerived() || resource.isHidden()) {
                return false;
            }
            long modstamp = resource.getLocalTimeStamp();
            if (modstamp > this.timestamp) {
                this.timestamp = modstamp;
            }
            return true;
        }

        Date getTimestamp() {
            return this.timestamp == -1L ? null : new Date(this.timestamp);
        }
    }
}

