/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.mspec.model.MaterializationSpec;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.IResolverBackchannel;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.IStatus;

public class ResolutionContext
extends RMContext
implements IResolverBackchannel {
    private final ComponentQuery componentQuery;
    private HashMap<IComponentIdentifier, GeneratorNode> generators;
    private final ResolutionContext parentContext;
    private final HashMap<ComponentRequest, List<ResolverDecision>> decisionLog = new HashMap();

    public ResolutionContext(ComponentQuery componentQuery) {
        this(componentQuery, null);
    }

    public ResolutionContext(ComponentQuery componentQuery, ResolutionContext parentContext) {
        super((Map<String, ? extends Object>)(parentContext == null ? componentQuery.getGlobalProperties() : new UnmodifiableMapUnion<String, Object>(componentQuery.getGlobalProperties(), parentContext)));
        this.componentQuery = componentQuery;
        this.parentContext = parentContext;
        if (parentContext != null) {
            this.setSilentStatus(parentContext.isSilentStatus());
        }
    }

    public ResolutionContext(MaterializationSpec mspec, ComponentQuery componentQuery) {
        super((Map<String, ? extends Object>)new UnmodifiableMapUnion<String, String>(componentQuery.getGlobalProperties(), mspec.getProperties()));
        this.componentQuery = componentQuery;
        this.parentContext = null;
    }

    @Override
    public synchronized void addRequestStatus(IComponentRequest request, IStatus resolveStatus) {
        if (this.parentContext != null) {
            this.parentContext.addRequestStatus(request, resolveStatus);
        } else {
            super.addRequestStatus(request, resolveStatus);
        }
    }

    @Override
    public void addTagInfo(ComponentRequest request, String info) {
        if (this.parentContext != null) {
            this.parentContext.addTagInfo(request, info);
        } else {
            super.addTagInfo(request, info);
        }
    }

    @Override
    public synchronized Map<String, String> getBindingProperties() {
        return this.parentContext != null ? this.parentContext.getBindingProperties() : super.getBindingProperties();
    }

    @Override
    public ComponentQuery getComponentQuery() {
        return this.componentQuery;
    }

    public synchronized List<ResolverDecision> getDecisionLog(IComponentRequest request) {
        if (this.parentContext != null) {
            return this.parentContext.getDecisionLog(request);
        }
        return Utils.createUnmodifiableList((Collection)this.decisionLog.get(request));
    }

    public GeneratorNode getGeneratorNode(ComponentRequest request) {
        if (this.generators != null) {
            for (GeneratorNode generator : this.generators.values()) {
                if (!request.designates(generator.getGeneratesId())) continue;
                return generator;
            }
        }
        return this.parentContext == null ? null : this.parentContext.getGeneratorNode(request);
    }

    @Override
    public Map<String, ? extends Object> getProperties(ComponentName cName) {
        IAdvisorNode parentNode = null;
        IAdvisorNode node = null;
        Map<String, ? extends Object> p = super.getProperties(cName);
        if (this.parentContext != null) {
            parentNode = this.parentContext.getComponentQuery().getMatchingNode(cName, this);
        }
        node = this.getComponentQuery().getMatchingNode(cName, this);
        if (parentNode == null && node == null) {
            return p;
        }
        if (parentNode != null) {
            p = new UnmodifiableMapUnion<String, Object>(parentNode.getProperties(), p);
        }
        if (node != null && node != parentNode) {
            p = new UnmodifiableMapUnion<String, Object>(node.getProperties(), p);
        }
        return p;
    }

    @Override
    public IStatus getStatus() {
        return this.parentContext != null ? this.parentContext.getStatus() : super.getStatus();
    }

    @Override
    public Map<ComponentRequest, RMContext.TagInfo> getTagInfos() {
        return this.parentContext != null ? this.parentContext.getTagInfos() : super.getTagInfos();
    }

    @Override
    public Map<UUID, Object> getUserCache() {
        return this.parentContext != null ? this.parentContext.getUserCache() : super.getUserCache();
    }

    @Override
    public boolean isContinueOnError() {
        return this.parentContext != null ? this.parentContext.isContinueOnError() : super.isContinueOnError();
    }

    @Override
    public synchronized ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        if (this.parentContext != null) {
            return this.parentContext.logDecision(request, decisionType, args);
        }
        List<ResolverDecision> decisions = this.decisionLog.get(request);
        if (decisions == null) {
            decisions = new ArrayList<ResolverDecision>();
            this.decisionLog.put(request, decisions);
        }
        ResolverDecision decision = new ResolverDecision(request, decisionType, args);
        decisions.add(decision);
        if (!this.isSilentStatus()) {
            CorePlugin.getLogger().debug("%s: %s", new Object[]{request, decision});
        }
        return decision;
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.logDecision(this.getComponentQuery().getExpandedRootRequest(this), decisionType, args);
    }

    @Override
    public void setContinueOnError(boolean flag) {
        if (this.parentContext != null) {
            this.parentContext.setContinueOnError(flag);
        } else {
            super.setContinueOnError(flag);
        }
    }

    public void setGenerators(CSpec cspec, Collection<? extends IGenerator> generatorList) {
        for (IGenerator iGenerator : generatorList) {
            if (this.generators == null) {
                this.generators = new HashMap();
            }
            this.generators.put(iGenerator.getGeneratedIdentifier(), new GeneratorNode(cspec, iGenerator));
        }
    }
}

