/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.QualifiedDependency;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.CircularDependencyException;
import org.eclipse.buckminster.core.cspec.model.Generator;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.GeneratorNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.metadata.model.ResolvedNode;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class ResolverNode {
    private static final ResolverNode[] noChildren = new ResolverNode[0];
    private ResolverNode[] children;
    private GeneratorNode generatorNode;
    private boolean invalidateRun;
    private NodeQuery query;
    private Resolution resolution;
    private boolean forceUnresolved;
    private final String tagInfo;

    public ResolverNode(NodeQuery query, String tagInfo) {
        this.query = query;
        this.children = noChildren;
        this.tagInfo = tagInfo;
        if (tagInfo != null) {
            query.getContext().addTagInfo(query.getComponentRequest(), tagInfo);
        }
    }

    public synchronized void addDependencyQualification(QualifiedDependency newQDep, String tagInf) throws CoreException {
        NodeQuery qualifiedQuery = this.query.addDependencyQualification(newQDep);
        if (qualifiedQuery == this.query) {
            return;
        }
        VersionRange newVd = qualifiedQuery.getVersionRange();
        if (this.resolution != null && (newVd == null || newVd.isIncluded(this.resolution.getVersion())) && this.query.getQualifiedDependency().hasAllAttributes(qualifiedQuery.getRequiredAttributes())) {
            this.query = qualifiedQuery;
            if (this.tagInfo != null) {
                qualifiedQuery.getContext().addTagInfo(qualifiedQuery.getComponentRequest(), tagInf);
            }
            return;
        }
        this.resolution = null;
        this.children = noChildren;
        this.query = qualifiedQuery;
        this.invalidateRun = true;
        if (this.tagInfo != null) {
            qualifiedQuery.getContext().addTagInfo(qualifiedQuery.getComponentRequest(), tagInf);
        }
    }

    public BOMNode collectNodes(Map<UUID, BOMNode> nodeMap, Stack<Resolution> circularDepTrap, boolean sameTop) throws CoreException {
        List<BOMNode> childNodes;
        if (this.query.skipComponent()) {
            return null;
        }
        if (this.generatorNode != null) {
            return this.generatorNode;
        }
        if (this.resolution == null) {
            return new UnresolvedNode(this.query.getQualifiedDependency());
        }
        UUID myID = this.resolution.getId();
        BOMNode node = nodeMap.get(myID);
        if (node != null) {
            return node;
        }
        if (circularDepTrap.contains(this.resolution)) {
            if (this.query.allowCircularDependency()) {
                return null;
            }
            ArrayList<String> attrs = new ArrayList<String>(circularDepTrap.size());
            for (Resolution res : circularDepTrap) {
                attrs.add(res.getCSpec().getName());
            }
            attrs.add(this.resolution.getName());
            throw new CircularDependencyException(attrs);
        }
        boolean transitive = true;
        if ("osgi.bundle".equals(this.resolution.getComponentTypeId())) {
            transitive = !this.resolution.getName().endsWith(".source");
        }
        int top = this.children.length;
        ComponentQuery cquery = this.query.getComponentQuery();
        if (transitive && top > 0) {
            try {
                ArrayList<BOMNode> childNodeArr = new ArrayList<BOMNode>(top);
                circularDepTrap.push(this.resolution);
                ResolverNode[] resolverNodeArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    ResolverNode child = resolverNodeArray[n2];
                    boolean sameChildTop = cquery.equals(child.query.getComponentQuery());
                    BOMNode childNode = child.collectNodes(nodeMap, circularDepTrap, sameChildTop);
                    if (childNode == null) {
                        String depName = child.getQuery().getComponentRequest().getName();
                        CSpec cspec = this.resolution.getCSpec();
                        CSpecBuilder bld = new CSpecBuilder();
                        bld.initFrom(cspec);
                        for (IAttribute iAttribute : cspec.getAttributes().values()) {
                            for (IPrerequisite iPrerequisite : iAttribute.getPrerequisites()) {
                                if (!depName.equals(iPrerequisite.getComponentName())) continue;
                                ((TopLevelAttributeBuilder)bld.getAttribute(iAttribute.getName())).removePrerequisite(iPrerequisite);
                            }
                        }
                        bld.removeDependency(depName);
                        cspec = bld.createCSpec();
                        this.resolution = new Resolution(cspec, this.resolution);
                    } else {
                        childNodeArr.add(childNode);
                    }
                    ++n2;
                }
                circularDepTrap.pop();
                childNodes = childNodeArr;
            }
            catch (CircularDependencyException e) {
                if (this.query.allowCircularDependency()) {
                    return null;
                }
                throw e;
            }
        } else {
            childNodes = Collections.emptyList();
        }
        node = new ResolvedNode(this.resolution, childNodes);
        if (!sameTop) {
            node = BillOfMaterials.create(node, cquery);
        }
        nodeMap.put(myID, node);
        return node;
    }

    public synchronized void forceUnresolved() {
        this.resolution = null;
        this.children = noChildren;
        this.invalidateRun = true;
        this.forceUnresolved = true;
    }

    public boolean isForceUnresolved() {
        return this.forceUnresolved;
    }

    public boolean isResolved() {
        return this.resolution != null;
    }

    public synchronized void setResolution(Resolution resolution, ResolverNode[] children) {
        if (!this.invalidateRun) {
            this.resolution = resolution;
            this.children = children == null ? noChildren : children;
        }
    }

    public synchronized ResolutionContext startResolvingChildren(BOMNode node) throws CoreException {
        CSpec cspec;
        Collection<Generator> generators;
        ResolutionContext originalContext;
        Resolution nodeRes = node.getResolution();
        if (this.invalidateRun || nodeRes == null) {
            return null;
        }
        ComponentQuery cquery = node.getQuery();
        ResolutionContext context = originalContext = this.query.getResolutionContext();
        if (cquery != null && !cquery.equals(context.getComponentQuery())) {
            context = new ResolutionContext(cquery, context);
        }
        if ((generators = (cspec = nodeRes.getCSpec()).getGeneratorList()).size() > 0) {
            if (context == originalContext) {
                context = new ResolutionContext(originalContext.getComponentQuery(), originalContext);
            }
            context.setGenerators(cspec, generators);
        }
        if (context != originalContext) {
            this.query = context.getNodeQuery(this.query.getQualifiedDependency());
        }
        return context;
    }

    synchronized void clearInvalidationFlag() {
        if (!this.forceUnresolved) {
            this.invalidateRun = false;
        }
    }

    NodeQuery getQuery() {
        return this.query;
    }

    String getTagInfo() {
        return this.tagInfo;
    }

    boolean isInvalidated() {
        return this.invalidateRun;
    }

    void setGeneratorNode(GeneratorNode generatorNode) {
        this.generatorNode = generatorNode;
    }
}

