/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import org.eclipse.buckminster.core.rmap.model.Matcher;
import org.eclipse.buckminster.core.rmap.model.ResourceMap;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Locator
extends Matcher {
    public static final String TAG = "locator";
    public static final String ATTR_FAIL_ON_ERROR = "failOnError";
    public static final String ATTR_SEARCH_PATH_REF = "searchPathRef";
    private final String searchPath;
    private final boolean failOnError;

    public Locator(ResourceMap owner, String pattern, String searchPath) {
        this(owner, pattern, searchPath, null, true);
    }

    public Locator(ResourceMap owner, String pattern, String searchPath, Filter resolutionFilter) {
        this(owner, pattern, searchPath, resolutionFilter, true);
    }

    public Locator(ResourceMap owner, String pattern, String searchPath, Filter resolutionFilter, boolean failOnError) {
        super(owner, pattern, resolutionFilter);
        this.searchPath = searchPath;
        this.failOnError = failOnError;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public String getSearchPath() {
        return this.searchPath;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_SEARCH_PATH_REF, (String)this.searchPath);
        if (!this.failOnError) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_FAIL_ON_ERROR, (String)Boolean.toString(this.failOnError));
        }
        super.addAttributes(attrs);
    }
}

