/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.common.model.SAXEmitter;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.helpers.UnmodifiableMapUnion;
import org.eclipse.buckminster.core.metadata.ReferentialIntegrityException;
import org.eclipse.buckminster.core.metadata.StorageManager;
import org.eclipse.buckminster.core.metadata.model.IUUIDPersisted;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.sax.UUIDKeyed;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Provider
extends UUIDKeyed
implements IUUIDPersisted {
    public static final String ATTR_COMPONENT_TYPES = "componentTypes";
    public static final String ATTR_ALGORITHM = "algorithm";
    public static final String ATTR_READER_TYPE = "readerType";
    public static final String ATTR_RESOLUTION_FILTER = "resolutionFilter";
    public static final String ATTR_VERSION_CONVERTER = "versionConverter";
    public static final String TAG = "provider";
    public static final String TAG_URI = "uri";
    public static final int SEQUENCE_NUMBER = 2;
    public static final String TAG_DIGEST = "digest";
    private final Documentation documentation;
    private final String[] componentTypeIDs;
    private final String readerTypeId;
    private final Format uri;
    private final Format digest;
    private final String digestAlgorithm;
    private final VersionConverterDesc versionConverter;
    private final SearchPath searchPath;
    private final URIMatcher uriMatcher;
    private final Filter resolutionFilter;
    private final Map<String, String> properties;

    public static Provider immutableProvider(String readerType, String componentType, String uri) {
        return Provider.immutableProvider(readerType, componentType, uri, null);
    }

    public static Provider immutableProvider(String readerType, String componentType, String uri, Filter resolutionFilter) {
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("buckminster.mutable", "false");
        props.put("buckminster.source", "false");
        return new Provider(null, readerType, new String[]{componentType}, null, new Format(uri), null, null, resolutionFilter, props, null, null);
    }

    public Provider(SearchPath searchPath, String remoteReaderType, String[] componentTypeIDs, VersionConverterDesc versionConverterDesc, Format uri, Format digest, String digestAlgorithm, Filter resolutionFilter, Map<String, String> properties, URIMatcher uriMatcher, Documentation documentation) {
        this.searchPath = searchPath;
        this.readerTypeId = remoteReaderType;
        this.componentTypeIDs = componentTypeIDs == null ? Trivial.EMPTY_STRING_ARRAY : componentTypeIDs;
        this.versionConverter = versionConverterDesc;
        this.uri = uri;
        this.digest = digest;
        this.digestAlgorithm = digestAlgorithm;
        this.resolutionFilter = resolutionFilter;
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.uriMatcher = uriMatcher;
        this.documentation = documentation;
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        prefixMappings.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public ProviderMatch findMatch(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        ProviderScore score = query.getProviderScore(this.isMutable(), this.hasSource());
        if (score == ProviderScore.REJECTED) {
            ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, this.getReaderTypeId(), this.getProviderURI(query), Messages.Score_is_below_threshold);
            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
            return null;
        }
        if (this.uriMatcher != null) {
            ProviderMatch result = this.uriMatcher.getMatch(this, query, monitor);
            if (result == null) {
                ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, this.getReaderTypeId(), this.getProviderURI(query), "matcher didn't match any entries");
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
            }
            return result;
        }
        IVersionFinder versionFinder = null;
        monitor.beginTask(null, 120);
        try {
            ComponentRequest request = query.getComponentRequest();
            String componentTypeID = request.getComponentTypeID();
            IComponentType[] componentTypes = this.getComponentTypes();
            if (componentTypeID != null) {
                boolean found = false;
                int idx = componentTypes.length;
                while (--idx >= 0) {
                    IComponentType ctype = componentTypes[idx];
                    if (!ctype.getId().equals(componentTypeID)) continue;
                    componentTypes = new IComponentType[]{ctype};
                    found = true;
                    break;
                }
                if (!found) {
                    if (!this.getReaderTypeId().equals("eclipse.platform")) {
                        ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, this.getReaderTypeId(), this.getProviderURI(query), String.format(NLS.bind((String)Messages.Components_of_type_0_are_not_supported, (Object)componentTypeID), new Object[0]));
                        problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), null));
                    }
                    return null;
                }
            }
            VersionMatch candidate = null;
            IComponentType ctypeUsed = null;
            CoreException problem = null;
            try {
                IComponentType[] iComponentTypeArray = componentTypes;
                int n = componentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    block19: {
                        IComponentType ctype = iComponentTypeArray[n2];
                        try {
                            versionFinder = this.getReaderType().getVersionFinder(this, ctype, query, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
                            candidate = versionFinder.getBestVersion(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
                            if (candidate == null) break block19;
                            ctypeUsed = ctype;
                            break;
                        }
                        catch (MissingCSpecSourceException missingCSpecSourceException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                problem = e;
            }
            if (candidate == null) {
                ResolverDecision decision = query.logDecision(ResolverDecisionType.REJECTING_PROVIDER, this.getReaderTypeId(), this.getProviderURI(query), Messages.No_component_match_was_found);
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, decision.toString(), problem == null ? null : BuckminsterException.unwind((Throwable)problem)));
                return null;
            }
            query.logDecision(ResolverDecisionType.MATCH_FOUND, new Object[]{candidate});
            ProviderMatch providerMatch = versionFinder.getProviderMatch(candidate, ctypeUsed, score);
            return providerMatch;
        }
        finally {
            if (versionFinder != null) {
                versionFinder.close();
            }
            monitor.done();
        }
    }

    public final String[] getComponentTypeIDs() {
        return this.componentTypeIDs;
    }

    public final IComponentType[] getComponentTypes() throws CoreException {
        CorePlugin plugin = CorePlugin.getDefault();
        int idx = this.componentTypeIDs.length;
        IComponentType[] ctypes = new IComponentType[idx];
        while (--idx >= 0) {
            ctypes[idx] = plugin.getComponentType(this.componentTypeIDs[idx]);
        }
        return ctypes;
    }

    public IConnectContext getConnectContext() {
        return null;
    }

    public IConnectContext getConnectContext(Map<String, ? extends Object> props) {
        return null;
    }

    public String getDefaultTag() {
        return TAG;
    }

    public final String getDigest(Map<String, String> props) {
        return this.digest == null ? null : (String)this.digest.getValue(this.getProperties(props));
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    public Map<String, ? extends Object> getProperties(Map<String, ? extends Object> props) {
        if (!this.properties.isEmpty()) {
            props = new UnmodifiableMapUnion<String, String>(props, this.properties);
        }
        if (this.searchPath != null) {
            props = this.searchPath.getResourceMap().getProperties(props);
        }
        return props;
    }

    public Map<String, String> getProviderProperties() {
        return this.properties;
    }

    public final IReaderType getReaderType() throws CoreException {
        return CorePlugin.getDefault().getReaderType(this.readerTypeId);
    }

    public final String getReaderTypeId() {
        return this.readerTypeId;
    }

    public Filter getResolutionFilter() {
        return this.resolutionFilter;
    }

    public final SearchPath getSearchPath() {
        return this.searchPath;
    }

    public final Format getURI() {
        return this.uri;
    }

    public final String getURI(Map<String, ? extends Object> props) {
        return (String)this.uri.getValue(this.getProperties(props));
    }

    public URIMatcher getURIMatcher() {
        return this.uriMatcher;
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        VersionConverterDesc vcd = this.getVersionConverterDesc();
        return vcd == null ? null : vcd.getVersionConverter();
    }

    public final VersionConverterDesc getVersionConverterDesc() {
        return this.versionConverter;
    }

    public boolean hasLocalCache() {
        return false;
    }

    public final boolean hasSource() {
        String source = this.properties.get("buckminster.source");
        return source == null ? true : Boolean.parseBoolean(source);
    }

    public boolean isFilterMatchFor(NodeQuery query, Filter[] failingFilter) {
        if (this.resolutionFilter == null) {
            return true;
        }
        Map<String, String[]> attributeUsageMap = query.getContext().getFilterAttributeUsageMap();
        Filter resFilter = this.getResolutionFilter();
        Map<String, ? extends Object> props = query.getProperties();
        this.resolutionFilter.addConsultedAttributes(attributeUsageMap);
        if (this.resolutionFilter.matchCase(props)) {
            return true;
        }
        if (failingFilter != null) {
            failingFilter[0] = resFilter;
        }
        return false;
    }

    public final boolean isMutable() {
        String mutable = this.properties.get("buckminster.mutable");
        return mutable == null ? true : Boolean.parseBoolean(mutable);
    }

    @Override
    public boolean isPersisted(StorageManager sm) throws CoreException {
        return sm.getProviders().contains(this);
    }

    @Override
    public void remove(StorageManager sm) throws CoreException {
        UUID thisId = this.getId();
        if (!sm.getResolutions().getReferencingKeys(thisId, "providerId").isEmpty()) {
            throw new ReferentialIntegrityException(this, "remove", Messages.Referenced_from_Resolution);
        }
        sm.getProviders().removeElement(thisId);
    }

    @Override
    public void store(StorageManager sm) throws CoreException {
        sm.getProviders().putElement(this);
    }

    public boolean supportsComponentType(String componentTypeID) {
        if (componentTypeID == null) {
            return true;
        }
        String[] componentTypes = this.getComponentTypeIDs();
        int idx = componentTypes.length;
        while (--idx >= 0) {
            if (!componentTypeID.equals(componentTypes[idx])) continue;
            return true;
        }
        return false;
    }

    public void toSax(ContentHandler handler) throws SAXException {
        handler.startDocument();
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        this.addPrefixMappings(prefixMappings);
        for (Map.Entry<String, String> pfxMapping : prefixMappings.entrySet()) {
            handler.startPrefixMapping(pfxMapping.getKey(), pfxMapping.getValue());
        }
        this.toSax(handler, "http://www.eclipse.org/buckminster/RMap-1.0", "rm", this.getDefaultTag());
        for (String pfx : prefixMappings.keySet()) {
            handler.endPrefixMapping(pfx);
        }
        handler.endDocument();
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_READER_TYPE, (String)this.readerTypeId);
        if (this.componentTypeIDs.length > 0) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_COMPONENT_TYPES, (String)TextUtils.concat(this.componentTypeIDs, ","));
        }
        if (this.resolutionFilter != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_RESOLUTION_FILTER, (String)this.resolutionFilter.toString());
        }
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        if (this.documentation != null) {
            this.documentation.toSax(handler, namespace, prefix, this.documentation.getDefaultTag());
        }
        if (this.uriMatcher != null) {
            this.uriMatcher.toSax(handler, namespace, prefix, this.uriMatcher.getDefaultTag());
        }
        this.uri.toSax(handler, namespace, prefix, TAG_URI);
        SAXEmitter.emitProperties(handler, this.properties, namespace, prefix, true, false);
        if (this.digest != null) {
            AttributesImpl attrs = new AttributesImpl();
            Utils.addAttribute((AttributesImpl)attrs, (String)"format", (String)this.digest.getFormat());
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_ALGORITHM, (String)this.digestAlgorithm);
            String qName = Utils.makeQualifiedName((String)prefix, (String)TAG_DIGEST);
            handler.startElement(namespace, TAG_DIGEST, qName, attrs);
            handler.endElement(namespace, TAG_DIGEST, qName);
        }
        if (this.versionConverter != null) {
            this.versionConverter.toSax(handler, namespace, prefix, this.versionConverter.getDefaultTag());
        }
    }

    protected String getElementNamespace(String namespace) {
        return "http://www.eclipse.org/buckminster/RMap-1.0";
    }

    protected String getElementPrefix(String prefix) {
        return "rm";
    }

    private String getProviderURI(NodeQuery query) {
        return this.searchPath == null ? this.getURI(query.getProperties()) : this.searchPath.getProviderURI(query, this);
    }
}

