/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.model;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.common.model.RxAssembly;
import org.eclipse.buckminster.core.common.model.RxPart;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.DateAndTimeUtils;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.URLCatalogReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class URIMatcher
extends RxAssembly {
    public static final String TAG = "matcher";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_VERSION_FORMAT = "versionFormat";
    public static final String ATTR_VERSION_TYPE = "versionType";
    public static final String COMPONENT_NAME_PARAM = "tagged.name";
    public static final String COMPONENT_VERSION_PARAM = "tagged.version";
    public static final String BRANCH_PARAM = "tagged.branch";
    public static final String TAG_PARAM = "tagged.tag";
    public static final String REVISION_PARAM = "tagged.revision";
    public static final String TIMESTAMP_PARAM = "tagged.timestamp";
    public static final String OS_PARAM = "tagged.os";
    public static final String WS_PARAM = "tagged.ws";
    public static final String ARCH_PARAM = "tagged.arch";
    public static final String NL_PARAM = "tagged.nl";
    public static final String ARTIFACT_INFO_PREFIX = "URIMetaData:";
    private final String base;
    private final IVersionFormat versionFormat;
    private final String componentType;

    private static Filter getFilter(Map<String, String> matchMap) {
        return FilterUtils.createFilter(matchMap.get(OS_PARAM), matchMap.get(WS_PARAM), matchMap.get(ARCH_PARAM), matchMap.get(NL_PARAM));
    }

    public URIMatcher(List<RxPart> parts, String base, IVersionFormat versionFormat, String componentType) throws CoreException, PatternSyntaxException {
        super(parts);
        this.base = base;
        this.versionFormat = versionFormat == null ? VersionHelper.getOSGiFormat() : versionFormat;
        this.componentType = componentType;
    }

    public Resolution createResolution(ProviderMatch pm) throws CoreException {
        Map<String, String> matchMap = pm.getMatcherMap();
        if (matchMap == null) {
            return null;
        }
        CSpecBuilder bld = new CSpecBuilder();
        bld.setName(matchMap.get(COMPONENT_NAME_PARAM));
        String tmp = matchMap.get(COMPONENT_VERSION_PARAM);
        if (tmp != null) {
            try {
                bld.setVersion(this.versionFormat.parse(tmp));
            }
            catch (IllegalArgumentException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        IComponentType ctype = pm.getComponentType();
        bld.setComponentTypeID(ctype.getId());
        bld.setFilter(URIMatcher.getFilter(matchMap));
        try {
            IFileInfo info = DownloadManager.readInfo((URL)URLUtils.normalizeToURL((String)pm.getRepositoryURI()), (IConnectContext)pm.getConnectContext());
            NodeQuery nq = pm.getNodeQuery();
            ResolutionBuilder resBld = new ResolutionBuilder(bld);
            resBld.getRequest().initFrom(nq.getComponentRequest());
            resBld.setAttributes(nq.getRequiredAttributes());
            resBld.setProvider(pm.getProvider());
            resBld.setRepository(pm.getProvider().getURI(nq.getProperties()));
            resBld.setComponentTypeId(ctype.getId());
            resBld.setVersionMatch(pm.getVersionMatch());
            resBld.setFileInfo(info);
            return new Resolution(resBld);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public String getBase() {
        return this.base;
    }

    @Override
    public String getDefaultTag() {
        return TAG;
    }

    /*
     * Unable to fully structure code
     */
    public ProviderMatch getMatch(Provider provider, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        logger = CorePlugin.getLogger();
        cq = query.getComponentRequest();
        candidate = null;
        candidateMap = null;
        providerProperties = provider.getProperties(query.getProperties());
        try {
            baseURL = new URL(ExpandingProperties.expand(providerProperties, this.base, 0));
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        urlsToMatch = URLCatalogReaderType.list(baseURL, query.getComponentQuery().getConnectContext(), monitor);
        if (urlsToMatch.length == 0) {
            logger.debug("No URL's for %s found on page %s", new Object[]{cq.getName(), baseURL});
            return null;
        }
        var14_12 = urlsToMatch;
        var13_13 = urlsToMatch.length;
        var12_14 = 0;
        while (var12_14 < var13_13) {
            urlToMatch = var14_12[var12_14];
            matchMap = this.getMatchMap(urlToMatch.toString());
            if (matchMap != null) {
                matchedName = matchMap.get("tagged.name");
                if (!cq.getName().equals(matchedName)) {
                    logger.debug("URI name %s does not match %s", new Object[]{matchedName, cq.getName()});
                } else {
                    version = null;
                    tmp = matchMap.get("tagged.version");
                    if (tmp != null) {
                        try {
                            version = this.versionFormat.parse(tmp);
                            vd = cq.getVersionRange();
                            if (vd != null && !vd.isIncluded(version)) {
                                logger.debug("URI version %s is not designated by %s", new Object[]{version, vd});
                            }
                            ** break block25
                        }
                        catch (IllegalArgumentException e) {
                            logger.warning((Throwable)e, e.getMessage(), new Object[0]);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((filter = URIMatcher.getFilter(matchMap)) != null && !filter.matchCase(providerProperties)) {
                            logger.debug("URI filter %s does not match current environment", new Object[]{filter});
                        } else {
                            vs = null;
                            tmp = matchMap.get("tagged.branch");
                            if (tmp != null) {
                                vs = VersionSelector.branch(tmp);
                            } else {
                                tmp = matchMap.get("tagged.tag");
                                if (tmp != null) {
                                    vs = VersionSelector.tag(tmp);
                                }
                            }
                            revision = -1L;
                            tmp = matchMap.get("tagged.revision");
                            if (tmp != null) {
                                try {
                                    revision = Long.parseLong(tmp);
                                }
                                catch (NumberFormatException e) {
                                    logger.warning((Throwable)e, e.getMessage(), new Object[0]);
                                }
                            }
                            timestamp = null;
                            tmp = matchMap.get("tagged.timestamp");
                            if (tmp != null) {
                                try {
                                    timestamp = DateAndTimeUtils.fromString(tmp);
                                }
                                catch (ParseException e) {
                                    logger.warning((Throwable)e, e.getMessage(), new Object[0]);
                                }
                            }
                            vm = new VersionMatch(version, vs, revision, timestamp, null);
                            if (candidate == null || query.compare(vm, candidate) > 0) {
                                candidate = vm;
                                candidateMap = matchMap;
                            }
                        }
                    }
                }
            }
            ++var12_14;
        }
        if (candidate == null) {
            return null;
        }
        query = query.getContext().getNodeQuery(query.getQualifiedDependency());
        query = new NodeQuery(query, candidateMap);
        pm = new ProviderMatch(provider, CorePlugin.getDefault().getComponentType(this.componentType), candidate, query);
        pm.setMatcherMap(candidateMap);
        return pm;
    }

    public IVersionFormat getVersionType() {
        return this.versionFormat;
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_BASE, (String)this.base);
        if (!this.versionFormat.equals(VersionHelper.getOSGiFormat())) {
            Utils.addAttribute((AttributesImpl)attrs, (String)ATTR_VERSION_FORMAT, (String)this.versionFormat.toString());
        }
    }
}

