/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.rmap.parser;

import java.util.regex.PatternSyntaxException;
import org.eclipse.buckminster.core.common.parser.RxAssemblyHandler;
import org.eclipse.buckminster.core.rmap.model.URIMatcher;
import org.eclipse.buckminster.core.rmap.parser.ProviderHandler;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class URIMatcherHandler
extends RxAssemblyHandler {
    public static final String TAG = "matcher";
    private String base;
    private IVersionFormat versionFormat;
    private String componentType = "unknown";

    public URIMatcherHandler(AbstractHandler parent) {
        super(parent);
        ProviderHandler parentHandler;
        String[] componentTypes;
        if (parent instanceof ProviderHandler && (componentTypes = (parentHandler = (ProviderHandler)this.getParentHandler()).getComponentTypes()).length == 1) {
            this.componentType = componentTypes[0];
        }
    }

    @Override
    public void handleAttributes(Attributes attrs) throws SAXException {
        super.handleAttributes(attrs);
        this.base = this.getStringValue(attrs, "base");
        String tmp = URIMatcherHandler.getOptionalStringValue((Attributes)attrs, (String)"versionFormat");
        if (tmp != null) {
            try {
                this.versionFormat = Version.compile((String)tmp);
            }
            catch (VersionFormatException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
        tmp = URIMatcherHandler.getOptionalStringValue((Attributes)attrs, (String)"versionType");
        if (tmp == null) {
            this.versionFormat = null;
        } else {
            try {
                this.versionFormat = VersionHelper.getVersionType(tmp).getFormat();
            }
            catch (CoreException e) {
                throw new SAXParseException(e.getMessage(), this.getDocumentLocator(), (Exception)((Object)e));
            }
        }
    }

    URIMatcher createURIMetaData() throws CoreException, PatternSyntaxException {
        return new URIMatcher(this.getParts(), this.base, this.versionFormat, this.componentType);
    }
}

