/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractSCCSVersionFinder;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.cvspkg.internal.CVSReaderType;
import org.eclipse.buckminster.cvspkg.internal.CVSSession;
import org.eclipse.buckminster.cvspkg.internal.RepositoryMetaData;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;

public class VersionFinder
extends AbstractSCCSVersionFinder {
    public static final Command.LocalOption HEADERS_ONLY = new CVSReaderType.MyLocalOption("-h");
    private RepositoryMetaData metaData;
    private final CVSSession session;

    public VersionFinder(Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        this.session = new CVSSession(provider.getURI(query.getProperties()));
    }

    public void close() {
        this.session.close();
    }

    protected boolean checkComponentExistence(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return true;
    }

    protected List<AbstractSCCSVersionFinder.RevisionEntry> getBranchesOrTags(boolean branches, IProgressMonitor monitor) throws CoreException {
        String[] names;
        Date timestamp;
        RepositoryMetaData repoMetaData = this.getMetaData(monitor, null);
        Date lastModTime = repoMetaData.getLastModification();
        if (lastModTime == null) {
            lastModTime = new Date();
        }
        if ((timestamp = this.getQuery().getTimestamp()) != null && timestamp.compareTo(lastModTime) < 0) {
            lastModTime = timestamp;
        }
        String[] stringArray = names = branches ? repoMetaData.getBranchNames() : repoMetaData.getTagNames();
        if (names.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractSCCSVersionFinder.RevisionEntry> entries = new ArrayList<AbstractSCCSVersionFinder.RevisionEntry>(names.length);
        String[] stringArray2 = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray2[n2];
            entries.add(new AbstractSCCSVersionFinder.RevisionEntry(name, lastModTime, -1L));
            ++n2;
        }
        return entries;
    }

    protected AbstractSCCSVersionFinder.RevisionEntry getTrunk(IProgressMonitor monitor) throws CoreException {
        CVSTag fixedTag = null;
        Date timestamp = this.getQuery().getTimestamp();
        if (timestamp != null) {
            fixedTag = new CVSTag(timestamp);
        }
        if (timestamp == null) {
            RepositoryMetaData repoMetaData = this.getMetaData(monitor, fixedTag);
            timestamp = repoMetaData.getLastModification();
            if (timestamp == null) {
                timestamp = new Date();
            }
        } else {
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        return new AbstractSCCSVersionFinder.RevisionEntry(null, timestamp, -1L);
    }

    private RepositoryMetaData getMetaData(IProgressMonitor monitor, CVSTag fixedTag) throws CoreException {
        if (this.metaData == null) {
            this.metaData = RepositoryMetaData.getMetaData(this.session, fixedTag, monitor);
        } else {
            MonitorUtils.complete((IProgressMonitor)monitor);
        }
        return this.metaData;
    }
}

