/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.UUID;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.download.IFetchPolicy;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.FileReader;
import org.eclipse.buckminster.download.policy.ArchivePolicy;
import org.eclipse.buckminster.download.policy.DigestPolicy;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.FileInfoBuilder;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class CacheImpl
implements ICache {
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private final File location;

    private static File asLocal(URL url) {
        try {
            url = FileLocator.resolve((URL)url);
            return "file".equalsIgnoreCase(url.getProtocol()) ? new File(url.toURI()) : null;
        }
        catch (IOException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public CacheImpl(File location) throws CoreException {
        this.location = location;
        if (!location.isDirectory() && !location.mkdirs()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_access_cache_0, (Object)location), (Object[])new Object[0]);
        }
    }

    public UUID getHash(String urlStr) {
        return UUID.nameUUIDFromBytes(urlStr.getBytes());
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public IFileInfo getRemoteInfo(URL remoteFile, IConnectContext cctx) throws CoreException, FileNotFoundException {
        File localFile = CacheImpl.asLocal(remoteFile);
        if (localFile != null) {
            return new FileInfoBuilder(localFile);
        }
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
        }
        FileReader reader = new FileReader(cctx);
        return reader.readInfo(remoteFile);
    }

    public File getSubFolder(String protocol, String domain) {
        File protoFolder = new File(this.location, protocol);
        if (domain == null) {
            domain = "localhost";
        }
        return new File(protoFolder, domain);
    }

    public File getSubFolder(URL url) {
        return this.getSubFolder(url.getProtocol(), url.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpToDate(IFetchPolicy policy, URL remoteFile, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        String urlStr;
        String string = urlStr = remoteFile.toString().intern();
        synchronized (string) {
            File localFile = CacheImpl.asLocal(remoteFile);
            if (localFile != null) {
                return localFile.canRead();
            }
            localFile = new File(this.getSubFolder(remoteFile), this.getHash(urlStr).toString());
            boolean bl = !policy.update(remoteFile, localFile, true, null, monitor);
            return bl;
        }
    }

    @Override
    public boolean isUpToDate(URL remoteFile, IConnectContext cctx, String remoteName, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
        }
        return this.isUpToDate(new ArchivePolicy(this, cctx, remoteName), remoteFile, monitor);
    }

    @Override
    public boolean isUpToDate(URL remoteFile, URL remoteDigest, IConnectContext cctx, String algorithm, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
            uh[0] = remoteDigest;
            DownloadManager.createConnectContext(uh);
            remoteDigest = uh[0];
        }
        return this.isUpToDate(new DigestPolicy(this, remoteDigest, cctx, algorithm, 30000), remoteFile, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream open(IFetchPolicy policy, URL remoteFile, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        String urlStr;
        File file = CacheImpl.asLocal(remoteFile);
        if (file != null) {
            if (fiHandle != null) {
                fiHandle[0] = new FileInfoBuilder(file);
            }
            return new FileInputStream(file);
        }
        URL[] uh = new URL[]{remoteFile};
        DownloadManager.createConnectContext(uh);
        remoteFile = uh[0];
        String string = urlStr = remoteFile.toString().intern();
        synchronized (string) {
            File localFile = new File(this.getSubFolder(remoteFile), this.getHash(urlStr).toString());
            policy.update(remoteFile, localFile, false, fiHandle, monitor);
            return new FileInputStream(localFile);
        }
    }

    @Override
    public InputStream open(URL remoteFile, IConnectContext cctx, String remoteName, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
        }
        return this.open(new ArchivePolicy(this, cctx, remoteName), remoteFile, fiHandle, monitor);
    }

    @Override
    public InputStream open(URL remoteFile, URL remoteDigest, IConnectContext cctx, String algorithm, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
        }
        return this.open(new DigestPolicy(this, remoteDigest, cctx, algorithm, 30000), remoteFile, fiHandle, monitor);
    }

    @Override
    public InputStream openRemote(URL remoteFile, IConnectContext cctx) throws CoreException, FileNotFoundException {
        File file = CacheImpl.asLocal(remoteFile);
        if (file != null) {
            return new FileInputStream(file);
        }
        if (cctx == null) {
            URL[] uh = new URL[]{remoteFile};
            cctx = DownloadManager.createConnectContext(uh);
            remoteFile = uh[0];
        }
        FileReader reader = new FileReader(cctx);
        return reader.read(remoteFile);
    }
}

