/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.download.policy;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.download.Installer;
import org.eclipse.buckminster.download.Messages;
import org.eclipse.buckminster.download.internal.FileReader;
import org.eclipse.buckminster.download.policy.AbstractFetchPolicy;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class ArchivePolicy
extends AbstractFetchPolicy {
    private static final Object THREADLOCK = new Object();
    private final String remoteName;
    private final IConnectContext connectContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mkdirs(File directory) throws CoreException {
        Object object = THREADLOCK;
        synchronized (object) {
            if (directory == null || directory.exists() && !directory.isDirectory()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.error_0_cause_1, (Object)NLS.bind((String)Messages.unable_to_create_directory_0, (Object)(directory != null ? directory : "(null)")), (Object)Messages.not_a_directory), (Object[])new Object[0]);
            }
            if (!directory.exists() && !directory.mkdirs()) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_create_directory_0, (Object)directory), (Object[])new Object[0]);
            }
        }
    }

    public ArchivePolicy(ICache cache, IConnectContext cctx, String remoteName) {
        super(cache);
        this.remoteName = remoteName;
        this.connectContext = cctx;
    }

    @Override
    public boolean update(URL remoteFile, File localFile, boolean checkOnly, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)1000);
        try {
            long localFileTS = localFile.lastModified();
            if (localFileTS != 0L) {
                IFileInfo fi;
                long localAge = System.currentTimeMillis() - localFileTS;
                if (localAge <= 30000L) {
                    if (fiHandle != null) {
                        fiHandle[0] = this.readLocalFileInfo(remoteFile);
                    }
                    return false;
                }
                try {
                    fi = this.getCache().getRemoteInfo(remoteFile, this.connectContext);
                    if (fiHandle != null) {
                        fiHandle[0] = fi;
                    }
                }
                catch (FileNotFoundException e) {
                    localFile.delete();
                    throw BuckminsterException.wrap((Throwable)e);
                }
                if (fi.getSize() == localFile.length() && fi.getLastModified() != 0L && fi.getLastModified() <= localFile.lastModified()) {
                    localFile.setLastModified(System.currentTimeMillis());
                    return false;
                }
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            if (checkOnly) {
                return true;
            }
            File tempFile = new File(String.valueOf(localFile.getPath()) + ".tmp");
            String fileName = this.readRemoteFile(remoteFile, tempFile, fiHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800));
            if (this.remoteName != null) {
                fileName = this.remoteName;
            }
            try {
                Installer.getInstaller(fileName, true).validate(tempFile, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            catch (CoreException e) {
                tempFile.delete();
                throw e;
            }
            ArchivePolicy.safeRename(tempFile, localFile);
            return true;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    protected String readRemoteFile(URL url, File localFile, IFileInfo[] fiHandle, IProgressMonitor monitor) throws CoreException {
        String string;
        FileOutputStream output = null;
        try {
            localFile = localFile.getCanonicalFile();
            File parentFolder = localFile.getParentFile();
            if (parentFolder != null) {
                ArchivePolicy.mkdirs(parentFolder);
            }
            output = new FileOutputStream(localFile);
            FileReader retriever = new FileReader(this.connectContext);
            retriever.readInto(url, output, monitor);
            IFileInfo fileInfo = retriever.getLastFileInfo();
            this.saveLocalFileInfo(url, fileInfo);
            if (fiHandle != null) {
                fiHandle[0] = fileInfo;
            }
            string = fileInfo.getRemoteName();
        }
        catch (IOException e) {
            try {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.close(output);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)output);
        return string;
    }
}

