/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.generic.model.tree;

import java.util.ArrayList;
import org.eclipse.buckminster.generic.model.tree.AbstractTreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeDataNode;
import org.eclipse.buckminster.generic.model.tree.ITreeParentDataNode;

public abstract class AbstractTreeParentDataNode
extends AbstractTreeDataNode
implements ITreeParentDataNode {
    private ArrayList<ITreeDataNode> children = new ArrayList();

    @Override
    public void addChild(ITreeDataNode child) {
        this.children.add(child);
        child.setParent(this);
        this.childNodeChanged(this);
    }

    @Override
    public void dispose() {
        this.dispose(this.getChildren());
    }

    @Override
    public ITreeDataNode findChild(Object data) {
        for (ITreeDataNode node : this.children) {
            if (!node.getData().equals(data)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ITreeDataNode[] getChildren() {
        return this.children.toArray(new ITreeDataNode[this.children.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void removeAllChildren() {
        for (ITreeDataNode child : this.children) {
            child.setParent(null);
        }
        this.children.clear();
        this.childNodeChanged(this);
    }

    @Override
    public void removeChild(ITreeDataNode child) {
        this.children.remove(child);
        child.setParent(null);
        this.childNodeChanged(this);
    }

    @Override
    public void replaceChild(ITreeDataNode child, ITreeDataNode newChild) {
        int idx = this.children.indexOf(child);
        this.children.set(idx, newChild);
        child.setParent(null);
        newChild.setParent(this);
        this.childNodeChanged(this);
    }

    @Override
    public void replaceChild(ITreeDataNode child, ITreeDataNode[] newChildren) {
        int idx = this.children.indexOf(child);
        this.children.remove(idx);
        child.setParent(null);
        int i = 0;
        while (i < newChildren.length) {
            this.children.add(idx + i, newChildren[i]);
            newChildren[i].setParent(this);
            ++i;
        }
        this.childNodeChanged(this);
    }

    private void dispose(ITreeDataNode[] childArray) {
        if (childArray == null || childArray.length < 1) {
            return;
        }
        int i = 0;
        while (i < childArray.length) {
            childArray[i].dispose();
            ++i;
        }
    }
}

