/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.eclipse.buckminster.jarprocessor.IConstants;
import org.eclipse.buckminster.jarprocessor.JarInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

abstract class RecursivePack200
implements IConstants {
    private final List<String> defaultArgs;
    static final Pattern EFFORT_PATTERN = Pattern.compile("^-(?:E|-effort=)([0-9])$");
    private static final Pattern stripDebugPattern = Pattern.compile("^-(?:G|-strip-debug)$");
    private static final Pattern noKeepFileOrderPattern = Pattern.compile("^-(?:O|-no-keep-file-order)$");
    private static final Pattern keepFileOrderPattern = Pattern.compile("^--keep-file-order$");
    private static final Pattern segmentLimitPattern = Pattern.compile("^-(?:S|-segment-limit=)([0-9]+)$");
    private static final Pattern deflateHintPattern = Pattern.compile("^-(?:H|-deflate-hint=)(true|false|keep)$");
    private static final Pattern modificationTimePatter = Pattern.compile("^-(?:m|-modification-time=)(latest|keep)$");
    private static final Pattern passFilePatter = Pattern.compile("^-(?:P|-pass-file=)(.+)$");
    final File tempDir;

    static ZipEntry createEntry(ZipEntry original) {
        ZipEntry copy = RecursivePack200.createEntry(original, original.getName());
        copy.setExtra(original.getExtra());
        return copy;
    }

    static ZipEntry createEntry(ZipEntry original, String name) {
        ZipEntry copy = new ZipEntry(name);
        copy.setComment(original.getComment());
        copy.setTime(original.getTime());
        return copy;
    }

    static Pack200.Unpacker getUnpacker() {
        return Pack200.newUnpacker();
    }

    RecursivePack200(File tempDir, List<String> defaultArgs) {
        this.defaultArgs = defaultArgs == null || defaultArgs.isEmpty() ? Collections.emptyList() : new ArrayList<String>(defaultArgs);
        this.tempDir = tempDir;
    }

    Pack200.Packer getPacker(JarInfo jarInfo) {
        int passFileSuffix = 1;
        ArrayList<String> args = new ArrayList<String>();
        jarInfo.appendArgs(args);
        args.addAll(this.defaultArgs);
        HashSet<String> propsAdded = new HashSet<String>();
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap properties = packer.properties();
        if (!jarInfo.hasClasses()) {
            propsAdded.add("pack.effort");
            properties.put("pack.effort", "0");
        }
        for (String arg : args) {
            Matcher m = EFFORT_PATTERN.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.effort")) continue;
                properties.put("pack.effort", m.group(1));
                continue;
            }
            m = segmentLimitPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.segment.limit")) continue;
                properties.put("pack.segment.limit", m.group(1));
                continue;
            }
            m = noKeepFileOrderPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.keep.file.order")) continue;
                properties.put("pack.keep.file.order", "false");
                continue;
            }
            m = keepFileOrderPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.keep.file.order")) continue;
                properties.put("pack.keep.file.order", "true");
                continue;
            }
            m = stripDebugPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("strip.debug")) continue;
                properties.put("pack.code.attribute.LineNumberTable", "strip");
                properties.put("pack.code.attribute.LocalVariableTable", "strip");
                properties.put("pack.class.attribute.SourceFile", "strip");
                continue;
            }
            m = deflateHintPattern.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.deflate.hint")) continue;
                properties.put("pack.deflate.hint", m.group(1));
                continue;
            }
            m = modificationTimePatter.matcher(arg);
            if (m.matches()) {
                if (!propsAdded.add("pack.modification.time")) continue;
                properties.put("pack.modification.time", m.group(1));
                continue;
            }
            m = passFilePatter.matcher(arg);
            if (!m.matches()) continue;
            IPath path = Path.fromOSString((String)m.group(1));
            properties.put("pack.pass.file.." + passFileSuffix++, path.toPortableString());
        }
        return packer;
    }

    void pack(JarInfo jarInfo, InputStream in, OutputStream out) throws IOException {
        File packInputFile = null;
        try {
            this.tempDir.mkdirs();
            BufferedOutputStream tempOut = null;
            try {
                packInputFile = File.createTempFile("conditioned_", ".jar", this.tempDir);
                tempOut = new BufferedOutputStream(new FileOutputStream(packInputFile));
                IOUtils.copy((InputStream)in, (OutputStream)tempOut, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable) {
                IOUtils.close(tempOut);
                throw throwable;
            }
            IOUtils.close((Closeable)tempOut);
            Pack200.Packer packer = this.getPacker(jarInfo);
            packer.pack(new JarFile(packInputFile), out);
        }
        finally {
            if (packInputFile != null) {
                packInputFile.delete();
            }
        }
    }

    void unpack(InputStream in, OutputStream out) throws IOException {
        File unpackInputFile = null;
        try {
            this.tempDir.mkdirs();
            BufferedOutputStream tempOut = null;
            try {
                unpackInputFile = File.createTempFile("packed_", ".jar.pack.gz", this.tempDir);
                tempOut = new BufferedOutputStream(new FileOutputStream(unpackInputFile));
                IOUtils.copy((InputStream)in, (OutputStream)tempOut, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable) {
                IOUtils.close(tempOut);
                throw throwable;
            }
            IOUtils.close((Closeable)tempOut);
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            JarOutputStream jarOut = new JarOutputStream(out);
            unpacker.unpack(unpackInputFile, jarOut);
            jarOut.finish();
        }
        finally {
            if (unpackInputFile != null) {
                unpackInputFile.delete();
            }
        }
    }

    static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream wrapped) throws IOException {
            super(wrapped);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

