/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.IBuckminsterPreferenceConstants;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public abstract class BuckminsterPreferences
implements IBuckminsterPreferenceConstants {
    private static final IEclipsePreferences prefsNode = InstanceScope.INSTANCE.getNode("org.eclipse.buckminster.runtime");
    private static final IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode("org.eclipse.buckminster.runtime");

    static {
        defaultNode.putInt("logLevelConsole", 1);
        defaultNode.putInt("logLevelAntLogger", 2);
        defaultNode.putInt("logLevelEclipseLogger", 2);
        defaultNode.putBoolean("logEclipseToConsole", false);
        defaultNode.put("siteName", "default");
        defaultNode.put("queryResolverSortOrder", "rmap");
        defaultNode.putInt("connectionRetryCount", 3);
        defaultNode.putInt("connectionRetryDelay", 1);
        defaultNode.putBoolean("pref_console_show_on_message", false);
        defaultNode.putBoolean("pref_console_show_on_error", true);
        defaultNode.putBoolean("pref_console_limit_output", true);
        defaultNode.putInt("pref_console_high_water_mark", 500000);
        defaultNode.put("pref_console_message_color", "0,0,0");
        defaultNode.put("pref_console_error_color", "255,0,0");
        try {
            defaultNode.flush();
        }
        catch (BackingStoreException e) {
            Buckminster.getLogger().error(e, e.toString(), new Object[0]);
        }
    }

    public static void addListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        prefsNode.addPreferenceChangeListener(listener);
    }

    public static String createQueryResolverSortOrder(String[] sortOrder) {
        if (sortOrder == null || sortOrder.length == 0) {
            return null;
        }
        StringBuffer bld = new StringBuffer();
        int idx = 0;
        while (idx < sortOrder.length) {
            String resolverName = sortOrder[idx];
            if (resolverName != null && (resolverName = resolverName.trim()).length() != 0) {
                if (bld.length() > 0) {
                    bld.append(',');
                }
                bld.append(resolverName);
            }
            ++idx;
        }
        return bld.length() > 0 ? bld.toString() : null;
    }

    public static IPath getBuckminterProjectContents() {
        String tmp = prefsNode.get("bmProjectContents", null);
        return tmp == null ? null : new Path(tmp);
    }

    public static int getConnectionRetryCount() {
        return prefsNode.getInt("connectionRetryCount", 3);
    }

    public static int getConnectionRetryDelay() {
        return prefsNode.getInt("connectionRetryDelay", 1);
    }

    public static String getConsoleErrorColor() {
        return prefsNode.get("pref_console_error_color", "255,0,0");
    }

    public static int getConsoleHighWaterMark() {
        return prefsNode.getInt("pref_console_high_water_mark", 500000);
    }

    public static String getConsoleMessageColor() {
        return prefsNode.get("pref_console_message_color", "0,0,0");
    }

    public static IEclipsePreferences getDefaultNode() {
        return defaultNode;
    }

    public static int getLogLevelAntLogger() {
        return prefsNode.getInt("logLevelAntLogger", 2);
    }

    public static int getLogLevelConsole() {
        return prefsNode.getInt("logLevelConsole", 1);
    }

    public static int getLogLevelEclipseLogger() {
        return prefsNode.getInt("logLevelEclipseLogger", 2);
    }

    public static IEclipsePreferences getNode() {
        return prefsNode;
    }

    public static String[] getQueryResolverSortOrder() {
        String qrso = prefsNode.get("queryResolverSortOrder", "rmap");
        return qrso.split(",");
    }

    public static String getSiteName() {
        return prefsNode.get("siteName", "default");
    }

    public static boolean isConsoleLimitOutput() {
        return prefsNode.getBoolean("pref_console_limit_output", true);
    }

    public static boolean isConsoleShowOnError() {
        return prefsNode.getBoolean("pref_console_show_on_error", true);
    }

    public static boolean isConsoleShowOnMessage() {
        return prefsNode.getBoolean("pref_console_show_on_message", false);
    }

    public static boolean isCustomQuerySortOrder() {
        return prefsNode.getBoolean("customQueryResolverSort", false);
    }

    public static boolean isEclipseLoggerToConsole() {
        return prefsNode.getBoolean("logEclipseToConsole", false);
    }

    public static void removeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        prefsNode.removePreferenceChangeListener(listener);
    }

    public static void save() throws BackingStoreException {
        prefsNode.flush();
    }

    public static void setBuckminsterProjectContents(IPath path) {
        if (path == null) {
            prefsNode.remove("bmProjectContents");
        } else {
            prefsNode.put("bmProjectContents", path.toPortableString());
        }
    }

    public static void setConnectionRetryCount(int retryCount) {
        prefsNode.putInt("connectionRetryCount", retryCount);
    }

    public static void setConnectionRetryDelay(int retryDelay) {
        prefsNode.putInt("connectionRetryDelay", retryDelay);
    }

    public static void setConsoleErrorColor(String color) {
        if (color == null) {
            prefsNode.remove("pref_console_error_color");
        } else {
            prefsNode.put("pref_console_error_color", color);
        }
    }

    public static void setConsoleHighWaterMark(int waterMark) {
        prefsNode.putInt("pref_console_high_water_mark", waterMark);
    }

    public static void setConsoleLimitOutput(boolean flag) {
        prefsNode.putBoolean("pref_console_limit_output", flag);
    }

    public static void setConsoleMessageColor(String color) {
        if (color == null) {
            prefsNode.remove("pref_console_message_color");
        } else {
            prefsNode.put("pref_console_message_color", color);
        }
    }

    public static void setConsoleShowOnError(boolean flag) {
        prefsNode.putBoolean("pref_console_show_on_error", flag);
    }

    public static void setConsoleShowOnMessage(boolean flag) {
        prefsNode.putBoolean("pref_console_show_on_message", flag);
    }

    public static void setCustomQueryResolverSortOrder(boolean flag) {
        prefsNode.putBoolean("customQueryResolverSort", flag);
    }

    public static void setEclipseLoggerToConsole(boolean flag) {
        prefsNode.putBoolean("logEclipseToConsole", flag);
    }

    public static void setLogLevelAntLogger(int logLevel) {
        prefsNode.putInt("logLevelAntLogger", logLevel);
    }

    public static void setLogLevelConsole(int logLevel) {
        prefsNode.putInt("logLevelConsole", logLevel);
    }

    public static void setLogLevelEclipseLogger(int logLevel) {
        prefsNode.putInt("logLevelEclipseLogger", logLevel);
    }

    public static void setQueryResolverSortOrder(String[] sortOrder) {
        String sortOrderString = BuckminsterPreferences.createQueryResolverSortOrder(sortOrder);
        if (sortOrderString == null) {
            prefsNode.remove("queryResolverSortOrder");
        } else {
            prefsNode.put("queryResolverSortOrder", sortOrderString);
        }
    }

    public static void setSiteName(String siteName) {
        if (siteName == null) {
            prefsNode.remove("siteName");
        } else {
            prefsNode.put("siteName", siteName);
        }
    }
}

