/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;

public class ConfigureFetchAfterCloneTask
implements CloneOperation.PostCloneTask {
    private String fetchRefSpec;
    private final String remoteName;

    public ConfigureFetchAfterCloneTask(String remoteName, String fetchRefSpec) {
        this.remoteName = remoteName;
        this.fetchRefSpec = fetchRefSpec;
    }

    @Override
    public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
        try {
            RemoteConfig configToUse = new RemoteConfig((Config)repository.getConfig(), this.remoteName);
            if (this.fetchRefSpec != null) {
                configToUse.addFetchRefSpec(new RefSpec(this.fetchRefSpec));
            }
            configToUse.update((Config)repository.getConfig());
            repository.getConfig().save();
            Git git = new Git(repository);
            try {
                git.fetch().setRemote(this.remoteName).call();
            }
            catch (Exception e) {
                Activator.logError(NLS.bind((String)CoreText.ConfigureFetchAfterCloneTask_couldNotFetch, (Object)this.fetchRefSpec), e);
            }
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }
}

