/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class RevertCommitOperation
implements IEGitOperation {
    private final Repository repo;
    private final List<RevCommit> commits;
    private RevCommit newHead;
    private List<Ref> reverted;
    private MergeResult result;

    public RevertCommitOperation(Repository repository, List<RevCommit> commits) {
        this.repo = repository;
        this.commits = commits;
    }

    public RevCommit getNewHead() {
        return this.newHead;
    }

    public List<Ref> getRevertedRefs() {
        return this.reverted;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 2);
                pm.subTask(MessageFormat.format(CoreText.RevertCommitOperation_reverting, RevertCommitOperation.this.commits.size()));
                RevertCommand command = new Git(RevertCommitOperation.this.repo).revert();
                MergeStrategy strategy = Activator.getDefault().getPreferredMergeStrategy();
                if (strategy != null) {
                    command.setStrategy(strategy);
                }
                for (RevCommit commit : RevertCommitOperation.this.commits) {
                    command.include((AnyObjectId)commit);
                }
                try {
                    RevertCommitOperation.this.newHead = command.call();
                    RevertCommitOperation.this.reverted = command.getRevertedRefs();
                    RevertCommitOperation.this.result = command.getFailingResult();
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                pm.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(RevertCommitOperation.this.repo), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                pm.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repo);
    }

    public MergeResult getFailingResult() {
        return this.result;
    }
}

