/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cmdline;

import org.eclipse.buckminster.cmdline.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class BasicPreferenceHandler
implements IExecutableExtension {
    private static final String NAME_ATTRIB = "name";
    private static final String KEY_ATTRIB = "key";
    private static final String DESC_ATTRIB = "description";
    private static final char SLASH = '/';
    private String m_name;
    private String m_key;
    private String m_description;
    private static final IEclipsePreferences s_eclipsePrefs = Platform.getPreferencesService().getRootNode();

    public String get(String defaultValue) throws CoreException {
        String[] prefNodeAndKey = this.pathAsNodeAndKey(this.getKey());
        return s_eclipsePrefs.node(prefNodeAndKey[0]).get(prefNodeAndKey[1], defaultValue);
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final String getKey() {
        return this.m_key;
    }

    public final String getName() {
        return this.m_name;
    }

    public void set(String value) throws BackingStoreException {
        String key = this.getKey();
        if (key == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.No_handler_registered_for_preference_0, (Object)this.getName()));
        }
        String[] prefNodeAndKey = this.pathAsNodeAndKey(this.getKey());
        Preferences node = s_eclipsePrefs.node(prefNodeAndKey[0]);
        node.put(prefNodeAndKey[1], value);
        node.flush();
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.m_name = new StringBuffer(config.getDeclaringExtension().getNamespaceIdentifier()).append('.').append(config.getAttribute(NAME_ATTRIB)).toString();
        this.m_key = config.getAttribute(KEY_ATTRIB);
        this.m_description = config.getAttribute(DESC_ATTRIB);
    }

    public void unset() throws BackingStoreException {
        String[] prefNodeAndKey = this.pathAsNodeAndKey(this.getKey());
        Preferences node = s_eclipsePrefs.node(prefNodeAndKey[0]);
        node.remove(prefNodeAndKey[1]);
        node.flush();
    }

    protected final String[] pathAsNodeAndKey(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            throw new IllegalArgumentException(Messages.BasicPreferenceHandler_No_slash_in_preference_path);
        }
        return new String[]{path.substring(0, lastSlash), path.substring(lastSlash + 1)};
    }
}

